/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.fieldvisitor.FieldNamesProvidingStoredFieldsVisitor;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

final class TranslogDirectoryReader
extends DirectoryReader {
    private final TranslogLeafReader leafReader;

    TranslogDirectoryReader(ShardId shardId, Translog.Index operation, MappingLookup mappingLookup, DocumentParser documentParser, Analyzer analyzer, Runnable onSegmentCreated) throws IOException {
        this(new TranslogLeafReader(shardId, operation, mappingLookup, documentParser, analyzer, onSegmentCreated));
    }

    private TranslogDirectoryReader(TranslogLeafReader leafReader) throws IOException {
        super(leafReader.directory, new LeafReader[]{leafReader}, null);
        this.leafReader = leafReader;
    }

    private static UnsupportedOperationException unsupported() {
        assert (false) : "unsupported operation";
        return new UnsupportedOperationException();
    }

    public TranslogLeafReader getLeafReader() {
        return this.leafReader;
    }

    protected DirectoryReader doOpenIfChanged() {
        throw TranslogDirectoryReader.unsupported();
    }

    protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
        throw TranslogDirectoryReader.unsupported();
    }

    protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
        throw TranslogDirectoryReader.unsupported();
    }

    public long getVersion() {
        throw TranslogDirectoryReader.unsupported();
    }

    public boolean isCurrent() {
        throw TranslogDirectoryReader.unsupported();
    }

    public IndexCommit getIndexCommit() {
        throw TranslogDirectoryReader.unsupported();
    }

    protected void doClose() throws IOException {
        this.leafReader.close();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.leafReader.getReaderCacheHelper();
    }

    private static class TranslogLeafReader
    extends LeafReader {
        private static final FieldInfo FAKE_SOURCE_FIELD = new FieldInfo("_source", 1, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false);
        private static final FieldInfo FAKE_ROUTING_FIELD = new FieldInfo("_routing", 2, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false);
        private static final FieldInfo FAKE_ID_FIELD = new FieldInfo("_id", 3, false, false, false, IndexOptions.DOCS, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false);
        private static final Set<String> TRANSLOG_FIELD_NAMES = Set.of("_source", "_routing", "_id");
        private final ShardId shardId;
        private final Translog.Index operation;
        private final MappingLookup mappingLookup;
        private final DocumentParser documentParser;
        private final Analyzer analyzer;
        private final Directory directory;
        private final Runnable onSegmentCreated;
        private final AtomicReference<LeafReader> delegate = new AtomicReference();
        private final BytesRef uid;

        TranslogLeafReader(ShardId shardId, Translog.Index operation, MappingLookup mappingLookup, DocumentParser documentParser, Analyzer analyzer, Runnable onSegmentCreated) {
            this.shardId = shardId;
            this.operation = operation;
            this.mappingLookup = mappingLookup;
            this.documentParser = documentParser;
            this.analyzer = analyzer;
            this.onSegmentCreated = onSegmentCreated;
            this.directory = new ByteBuffersDirectory();
            this.uid = Uid.encodeId(operation.id());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LeafReader getDelegate() {
            this.ensureOpen();
            LeafReader reader = this.delegate.get();
            if (reader == null) {
                TranslogLeafReader translogLeafReader = this;
                synchronized (translogLeafReader) {
                    this.ensureOpen();
                    reader = this.delegate.get();
                    if (reader == null) {
                        reader = this.createInMemoryLeafReader();
                        LeafReader existing = this.delegate.getAndSet(reader);
                        assert (existing == null);
                        this.onSegmentCreated.run();
                    }
                }
            }
            return reader;
        }

        private LeafReader createInMemoryLeafReader() {
            LeafReader leafReader;
            assert (Thread.holdsLock((Object)this));
            ParsedDocument parsedDocs = this.documentParser.parseDocument(new SourceToParse(this.operation.id(), this.operation.source(), XContentHelper.xContentType(this.operation.source()), this.operation.routing(), Map.of()), this.mappingLookup);
            parsedDocs.updateSeqID(this.operation.seqNo(), this.operation.primaryTerm());
            parsedDocs.version().setLongValue(this.operation.version());
            IndexWriterConfig writeConfig = new IndexWriterConfig(this.analyzer).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            IndexWriter writer = new IndexWriter(this.directory, writeConfig);
            try {
                writer.addDocument((Iterable)parsedDocs.rootDoc());
                DirectoryReader reader = DirectoryReader.open((IndexWriter)writer);
                if (reader.leaves().size() != 1 || ((LeafReaderContext)reader.leaves().get(0)).reader().numDocs() != 1) {
                    reader.close();
                    throw new IllegalStateException("Expected a single document segment; but [" + reader.leaves().size() + " segments with " + ((LeafReaderContext)reader.leaves().get(0)).reader().numDocs() + " documents");
                }
                leafReader = ((LeafReaderContext)reader.leaves().get(0)).reader();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EngineException(this.shardId, "failed to create an in-memory segment for get [" + this.operation.id() + "]", e, new Object[0]);
                }
            }
            writer.close();
            return leafReader;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.getDelegate().getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }

        public Terms terms(String field) throws IOException {
            if (this.delegate.get() == null && field.equals("_id")) {
                return new FakeTerms(this.uid);
            }
            return this.getDelegate().terms(field);
        }

        public NumericDocValues getNumericDocValues(String field) throws IOException {
            if (this.delegate.get() == null) {
                if (field.equals("_version")) {
                    return new FakeNumericDocValues(this.operation.version());
                }
                if (field.equals("_seq_no")) {
                    return new FakeNumericDocValues(this.operation.seqNo());
                }
                if (field.equals("_primary_term")) {
                    return new FakeNumericDocValues(this.operation.primaryTerm());
                }
            }
            return this.getDelegate().getNumericDocValues(field);
        }

        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            return this.getDelegate().getBinaryDocValues(field);
        }

        public SortedDocValues getSortedDocValues(String field) throws IOException {
            return this.getDelegate().getSortedDocValues(field);
        }

        public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
            return this.getDelegate().getSortedNumericDocValues(field);
        }

        public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
            return this.getDelegate().getSortedSetDocValues(field);
        }

        public NumericDocValues getNormValues(String field) throws IOException {
            return this.getDelegate().getNormValues(field);
        }

        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            return this.getDelegate().getFloatVectorValues(field);
        }

        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            return this.getDelegate().getByteVectorValues(field);
        }

        public TopDocs searchNearestVectors(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
            return this.getDelegate().searchNearestVectors(field, target, k, acceptDocs, visitedLimit);
        }

        public TopDocs searchNearestVectors(String field, byte[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
            return this.getDelegate().searchNearestVectors(field, target, k, acceptDocs, visitedLimit);
        }

        public FieldInfos getFieldInfos() {
            return this.getDelegate().getFieldInfos();
        }

        public Bits getLiveDocs() {
            return null;
        }

        public PointValues getPointValues(String field) throws IOException {
            return this.getDelegate().getPointValues(field);
        }

        public void checkIntegrity() throws IOException {
        }

        public LeafMetaData getMetaData() {
            return this.getDelegate().getMetaData();
        }

        public Fields getTermVectors(int docID) throws IOException {
            return this.getDelegate().getTermVectors(docID);
        }

        public TermVectors termVectors() throws IOException {
            return this.getDelegate().termVectors();
        }

        public StoredFields storedFields() throws IOException {
            return this.getDelegate().storedFields();
        }

        public int numDocs() {
            return 1;
        }

        public int maxDoc() {
            return 1;
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            assert (docID == 0);
            if (docID != 0) {
                throw new IllegalArgumentException("no such doc ID " + docID);
            }
            if (this.delegate.get() == null && visitor instanceof FieldNamesProvidingStoredFieldsVisitor && TRANSLOG_FIELD_NAMES.containsAll(((FieldNamesProvidingStoredFieldsVisitor)visitor).getFieldNames())) {
                this.readStoredFieldsDirectly(visitor);
                return;
            }
            this.getDelegate().document(docID, visitor);
        }

        private void readStoredFieldsDirectly(StoredFieldVisitor visitor) throws IOException {
            if (visitor.needsField(FAKE_SOURCE_FIELD) == StoredFieldVisitor.Status.YES) {
                BytesReference sourceBytes = this.operation.source();
                assert (BytesReference.toBytes(sourceBytes) == sourceBytes.toBytesRef().bytes);
                SourceFieldMapper mapper = this.mappingLookup.getMapping().getMetadataMapperByClass(SourceFieldMapper.class);
                if (mapper != null) {
                    try {
                        sourceBytes = mapper.applyFilters(sourceBytes, null);
                    }
                    catch (IOException e) {
                        throw new IOException("Failed to reapply filters after reading from translog", e);
                    }
                }
                if (sourceBytes != null) {
                    visitor.binaryField(FAKE_SOURCE_FIELD, BytesReference.toBytes(sourceBytes));
                }
            }
            if (this.operation.routing() != null && visitor.needsField(FAKE_ROUTING_FIELD) == StoredFieldVisitor.Status.YES) {
                visitor.stringField(FAKE_ROUTING_FIELD, this.operation.routing());
            }
            if (visitor.needsField(FAKE_ID_FIELD) == StoredFieldVisitor.Status.YES) {
                byte[] id = new byte[this.uid.length];
                System.arraycopy(this.uid.bytes, this.uid.offset, id, 0, this.uid.length);
                visitor.binaryField(FAKE_ID_FIELD, id);
            }
        }

        protected synchronized void doClose() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{(Closeable)this.delegate.get(), this.directory});
        }
    }

    private static class FakeNumericDocValues
    extends NumericDocValues {
        private final long value;
        private final DocIdSetIterator disi = DocIdSetIterator.all((int)1);

        FakeNumericDocValues(long value) {
            this.value = value;
        }

        public long longValue() {
            return this.value;
        }

        public boolean advanceExact(int target) throws IOException {
            return this.disi.advance(target) == target;
        }

        public int docID() {
            return this.disi.docID();
        }

        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        public long cost() {
            return this.disi.cost();
        }
    }

    private static class FakePostingsEnum
    extends PostingsEnum {
        private final BytesRef term;
        private int iter = -1;

        private FakePostingsEnum(BytesRef term) {
            this.term = term;
        }

        public int freq() {
            return 1;
        }

        public int nextPosition() {
            return 0;
        }

        public int startOffset() {
            return 0;
        }

        public int endOffset() {
            return this.term.length;
        }

        public BytesRef getPayload() {
            return null;
        }

        public int docID() {
            return this.iter > 0 ? Integer.MAX_VALUE : this.iter;
        }

        public int nextDoc() {
            return ++this.iter == 0 ? 0 : Integer.MAX_VALUE;
        }

        public int advance(int target) {
            int doc;
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        public long cost() {
            return 0L;
        }
    }

    private static class FakeTermsEnum
    extends BaseTermsEnum {
        private final BytesRef term;
        private long position = -1L;

        FakeTermsEnum(BytesRef term) {
            this.term = term;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            int cmp = text.compareTo(this.term);
            if (cmp == 0) {
                this.position = 0L;
                return TermsEnum.SeekStatus.FOUND;
            }
            if (cmp < 0) {
                this.position = 0L;
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            this.position = Long.MAX_VALUE;
            return TermsEnum.SeekStatus.END;
        }

        public void seekExact(long ord) throws IOException {
            this.position = ord;
        }

        public BytesRef term() throws IOException {
            assert (this.position == 0L);
            return this.term;
        }

        public long ord() throws IOException {
            return this.position;
        }

        public int docFreq() throws IOException {
            return 1;
        }

        public long totalTermFreq() throws IOException {
            return 1L;
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return new FakePostingsEnum(this.term);
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            throw TranslogDirectoryReader.unsupported();
        }

        public BytesRef next() throws IOException {
            return ++this.position == 0L ? this.term : null;
        }
    }

    private static class FakeTerms
    extends Terms {
        private final BytesRef uid;

        FakeTerms(BytesRef uid) {
            this.uid = uid;
        }

        public TermsEnum iterator() throws IOException {
            return new FakeTermsEnum(this.uid);
        }

        public long size() throws IOException {
            return 1L;
        }

        public long getSumTotalTermFreq() throws IOException {
            return 1L;
        }

        public long getSumDocFreq() throws IOException {
            return 1L;
        }

        public int getDocCount() throws IOException {
            return 1;
        }

        public boolean hasFreqs() {
            return false;
        }

        public boolean hasOffsets() {
            return false;
        }

        public boolean hasPositions() {
            return false;
        }

        public boolean hasPayloads() {
            return false;
        }
    }
}

