/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SourceValueFetcherIndexFieldData;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

public class SourceValueFetcherSortedDoubleIndexFieldData
extends SourceValueFetcherIndexFieldData<SortedNumericDoubleValues> {
    protected SourceValueFetcherSortedDoubleIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory) {
        super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
    }

    @Override
    public SourceValueFetcherIndexFieldData.SourceValueFetcherLeafFieldData<SortedNumericDoubleValues> loadDirect(LeafReaderContext context) throws Exception {
        return new SourceValueFetcherSortedDoubleLeafFieldData(this.toScriptFieldFactory, context, this.valueFetcher, this.sourceProvider);
    }

    private static class SourceValueFetcherSortedDoubleLeafFieldData
    extends SourceValueFetcherIndexFieldData.SourceValueFetcherLeafFieldData<SortedNumericDoubleValues> {
        private SourceValueFetcherSortedDoubleLeafFieldData(ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory, LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            super(toScriptFieldFactory, leafReaderContext, valueFetcher, sourceProvider);
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(new SourceValueFetcherSortedNumericDoubleValues(this.leafReaderContext, this.valueFetcher, this.sourceProvider), name);
        }
    }

    private static class SourceValueFetcherSortedNumericDoubleValues
    extends SortedNumericDoubleValues
    implements SourceValueFetcherIndexFieldData.ValueFetcherDocValues {
        private final LeafReaderContext leafReaderContext;
        private final ValueFetcher valueFetcher;
        private final SourceProvider sourceProvider;
        private final List<Double> values;
        private Iterator<Double> iterator;

        private SourceValueFetcherSortedNumericDoubleValues(LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            this.leafReaderContext = leafReaderContext;
            this.valueFetcher = valueFetcher;
            this.sourceProvider = sourceProvider;
            this.values = new ArrayList<Double>();
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            this.values.clear();
            Source source = this.sourceProvider.getSource(this.leafReaderContext, doc);
            for (Object value : this.valueFetcher.fetchValues(source, doc, Collections.emptyList())) {
                assert (value instanceof Number);
                this.values.add(((Number)value).doubleValue());
            }
            this.values.sort(Double::compare);
            this.iterator = this.values.iterator();
            return true;
        }

        @Override
        public int docValueCount() {
            return this.values.size();
        }

        @Override
        public double nextValue() throws IOException {
            assert (this.iterator.hasNext());
            return this.iterator.next();
        }
    }

    public static class Builder
    extends SourceValueFetcherIndexFieldData.Builder<SortedNumericDoubleValues> {
        public Builder(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory) {
            super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
        }

        public SourceValueFetcherSortedDoubleIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new SourceValueFetcherSortedDoubleIndexFieldData(this.fieldName, this.valuesSourceType, this.valueFetcher, this.sourceProvider, this.toScriptFieldFactory);
        }
    }
}

