/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.ToScriptFieldFactory;

public final class GlobalOrdinalsBuilder
extends Enum<GlobalOrdinalsBuilder> {
    private static final /* synthetic */ GlobalOrdinalsBuilder[] $VALUES;

    public static GlobalOrdinalsBuilder[] values() {
        return (GlobalOrdinalsBuilder[])$VALUES.clone();
    }

    public static GlobalOrdinalsBuilder valueOf(String name) {
        return Enum.valueOf(GlobalOrdinalsBuilder.class, name);
    }

    public static IndexOrdinalsFieldData build(IndexReader indexReader, IndexOrdinalsFieldData indexFieldData, CircuitBreakerService breakerService, Logger logger, ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory) throws IOException {
        assert (indexReader.leaves().size() > 1);
        long startTimeNS = System.nanoTime();
        LeafOrdinalsFieldData[] atomicFD = new LeafOrdinalsFieldData[indexReader.leaves().size()];
        SortedSetDocValues[] subs = new SortedSetDocValues[indexReader.leaves().size()];
        for (int i = 0; i < indexReader.leaves().size(); ++i) {
            atomicFD[i] = (LeafOrdinalsFieldData)indexFieldData.load((LeafReaderContext)indexReader.leaves().get(i));
            subs[i] = atomicFD[i].getOrdinalsValues();
        }
        OrdinalMap ordinalMap = OrdinalMap.build(null, (SortedSetDocValues[])subs, (float)0.25f);
        long memorySizeInBytes = ordinalMap.ramBytesUsed();
        breakerService.getBreaker("fielddata").addWithoutBreaking(memorySizeInBytes);
        if (logger.isDebugEnabled()) {
            logger.debug("global-ordinals [{}][{}] took [{}]", (Object)indexFieldData.getFieldName(), (Object)ordinalMap.getValueCount(), (Object)new TimeValue(System.nanoTime() - startTimeNS, TimeUnit.NANOSECONDS));
        }
        return new GlobalOrdinalsIndexFieldData(indexFieldData.getFieldName(), indexFieldData.getValuesSourceType(), atomicFD, ordinalMap, memorySizeInBytes, toScriptFieldFactory);
    }

    public static IndexOrdinalsFieldData buildEmpty(IndexReader indexReader, IndexOrdinalsFieldData indexFieldData, ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory) throws IOException {
        assert (indexReader.leaves().size() > 1);
        LeafOrdinalsFieldData[] atomicFD = new LeafOrdinalsFieldData[indexReader.leaves().size()];
        SortedSetDocValues[] subs = new SortedSetDocValues[indexReader.leaves().size()];
        for (int i = 0; i < indexReader.leaves().size(); ++i) {
            atomicFD[i] = new AbstractLeafOrdinalsFieldData((ToScriptFieldFactory)toScriptFieldFactory){

                @Override
                public SortedSetDocValues getOrdinalsValues() {
                    return DocValues.emptySortedSet();
                }

                public long ramBytesUsed() {
                    return 0L;
                }

                public void close() {
                }
            };
            subs[i] = atomicFD[i].getOrdinalsValues();
        }
        OrdinalMap ordinalMap = OrdinalMap.build(null, (SortedSetDocValues[])subs, (float)0.25f);
        return new GlobalOrdinalsIndexFieldData(indexFieldData.getFieldName(), indexFieldData.getValuesSourceType(), atomicFD, ordinalMap, 0L, toScriptFieldFactory);
    }

    private static /* synthetic */ GlobalOrdinalsBuilder[] $values() {
        return new GlobalOrdinalsBuilder[0];
    }

    static {
        $VALUES = GlobalOrdinalsBuilder.$values();
    }
}

