/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.StringLiteralDeduplicator;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;

public abstract class Mapper
implements ToXContentFragment,
Iterable<Mapper> {
    private final String simpleName;
    private static final StringLiteralDeduplicator fieldNameStringDeduplicator = new StringLiteralDeduplicator();

    public Mapper(String simpleName) {
        Objects.requireNonNull(simpleName);
        this.simpleName = Mapper.internFieldName(simpleName);
    }

    public final String simpleName() {
        return this.simpleName;
    }

    public abstract String name();

    public abstract String typeName();

    public abstract Mapper merge(Mapper var1, MapperBuilderContext var2);

    public abstract void validate(MappingLookup var1);

    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source");
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static String internFieldName(String fieldName) {
        return fieldNameStringDeduplicator.deduplicate(fieldName);
    }

    public static interface TypeParser {
        public Builder parse(String var1, Map<String, Object> var2, MappingParserContext var3) throws MapperParsingException;

        default public boolean supportsVersion(Version indexCreatedVersion) {
            return indexCreatedVersion.onOrAfter(Version.CURRENT.minimumIndexCompatibilityVersion());
        }
    }

    public static abstract class Builder {
        protected final String name;

        protected Builder(String name) {
            this.name = Mapper.internFieldName(name);
        }

        public String name() {
            return this.name;
        }

        public abstract Mapper build(MapperBuilderContext var1);
    }
}

