/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.flattened;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.xcontent.XContentParser;

class FlattenedFieldParser {
    static final String SEPARATOR = "\u0000";
    private static final byte SEPARATOR_BYTE = 0;
    private final String rootFieldName;
    private final String keyedFieldName;
    private final MappedFieldType fieldType;
    private final int depthLimit;
    private final int ignoreAbove;
    private final String nullValue;

    FlattenedFieldParser(String rootFieldName, String keyedFieldName, MappedFieldType fieldType, int depthLimit, int ignoreAbove, String nullValue) {
        this.rootFieldName = rootFieldName;
        this.keyedFieldName = keyedFieldName;
        this.fieldType = fieldType;
        this.depthLimit = depthLimit;
        this.ignoreAbove = ignoreAbove;
        this.nullValue = nullValue;
    }

    public List<IndexableField> parse(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        ContentPath path = new ContentPath();
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
        this.parseObject(parser, path, fields);
        return fields;
    }

    private void parseObject(XContentParser parser, ContentPath path, List<IndexableField> fields) throws IOException {
        String currentName = null;
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            assert (currentName != null);
            this.parseFieldValue(token, parser, path, currentName, fields);
        }
        return;
    }

    private void parseArray(XContentParser parser, ContentPath path, String currentName, List<IndexableField> fields) throws IOException {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            this.parseFieldValue(token, parser, path, currentName, fields);
        }
        return;
    }

    private void parseFieldValue(XContentParser.Token token, XContentParser parser, ContentPath path, String currentName, List<IndexableField> fields) throws IOException {
        if (token == XContentParser.Token.START_OBJECT) {
            path.add(currentName);
            this.validateDepthLimit(path);
            this.parseObject(parser, path, fields);
            path.remove();
        } else if (token == XContentParser.Token.START_ARRAY) {
            this.parseArray(parser, path, currentName, fields);
        } else if (token.isValue()) {
            String value = parser.text();
            this.addField(path, currentName, value, fields);
        } else if (token == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue != null) {
                this.addField(path, currentName, this.nullValue, fields);
            }
        } else {
            throw new IllegalArgumentException("Encountered unexpected token [" + token.toString() + "].");
        }
    }

    private void addField(ContentPath path, String currentName, String value, List<IndexableField> fields) {
        if (value.length() > this.ignoreAbove) {
            return;
        }
        String key = path.pathAsText(currentName);
        if (key.contains(SEPARATOR)) {
            throw new IllegalArgumentException("Keys in [flattened] fields cannot contain the reserved character \\0. Offending key: [" + key + "].");
        }
        String keyedValue = FlattenedFieldParser.createKeyedValue(key, value);
        BytesRef bytesKeyedValue = new BytesRef((CharSequence)keyedValue);
        if (bytesKeyedValue.length > 32766) {
            String msg = "Flattened field [" + this.rootFieldName + "] contains one immense field whose keyed encoding is longer than the allowed max length of 32766 bytes. Key length: " + key.length() + ", value length: " + value.length() + " for key starting with [" + key.substring(0, Math.min(key.length(), 50)) + "]";
            throw new IllegalArgumentException(msg);
        }
        BytesRef bytesValue = new BytesRef((CharSequence)value);
        if (this.fieldType.isIndexed()) {
            fields.add((IndexableField)new StringField(this.rootFieldName, bytesValue, Field.Store.NO));
            fields.add((IndexableField)new StringField(this.keyedFieldName, bytesKeyedValue, Field.Store.NO));
        }
        if (this.fieldType.hasDocValues()) {
            fields.add((IndexableField)new SortedSetDocValuesField(this.rootFieldName, bytesValue));
            fields.add((IndexableField)new SortedSetDocValuesField(this.keyedFieldName, bytesKeyedValue));
        }
    }

    private void validateDepthLimit(ContentPath path) {
        if (path.length() + 1 > this.depthLimit) {
            throw new IllegalArgumentException("The provided [flattened] field [" + this.rootFieldName + "] exceeds the maximum depth limit of [" + this.depthLimit + "].");
        }
    }

    static String createKeyedValue(String key, String value) {
        return key + SEPARATOR + value;
    }

    static BytesRef extractKey(BytesRef keyedValue) {
        int length;
        for (length = 0; length < keyedValue.length && keyedValue.bytes[keyedValue.offset + length] != 0; ++length) {
        }
        return new BytesRef(keyedValue.bytes, keyedValue.offset, length);
    }

    static BytesRef extractValue(BytesRef keyedValue) {
        int length;
        for (length = 0; length < keyedValue.length && keyedValue.bytes[keyedValue.offset + length] != 0; ++length) {
        }
        int valueStart = keyedValue.offset + length + 1;
        return new BytesRef(keyedValue.bytes, valueStart, keyedValue.length - valueStart);
    }
}

