/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.nio.ByteBuffer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;

public final class VectorEncoderDecoder {
    public static final byte INT_BYTES = 4;

    private VectorEncoderDecoder() {
    }

    public static int denseVectorLength(Version indexVersion, BytesRef vectorBR) {
        return indexVersion.onOrAfter(Version.V_7_5_0) ? (vectorBR.length - 4) / 4 : vectorBR.length / 4;
    }

    public static float decodeMagnitude(Version indexVersion, BytesRef vectorBR) {
        assert (indexVersion.onOrAfter(Version.V_7_5_0));
        ByteBuffer byteBuffer = ByteBuffer.wrap(vectorBR.bytes, vectorBR.offset, vectorBR.length);
        return byteBuffer.getFloat(vectorBR.offset + vectorBR.length - 4);
    }

    private static float calculateMagnitude(Version indexVersion, BytesRef vectorBR) {
        int length = VectorEncoderDecoder.denseVectorLength(indexVersion, vectorBR);
        ByteBuffer byteBuffer = ByteBuffer.wrap(vectorBR.bytes, vectorBR.offset, vectorBR.length);
        double magnitude = 0.0;
        for (int i = 0; i < length; ++i) {
            float value = byteBuffer.getFloat();
            magnitude += (double)(value * value);
        }
        magnitude = Math.sqrt(magnitude);
        return (float)magnitude;
    }

    public static float getMagnitude(Version indexVersion, BytesRef vectorBR) {
        if (vectorBR == null) {
            throw new IllegalArgumentException("A document doesn't have a value for a vector field!");
        }
        if (indexVersion.onOrAfter(Version.V_7_5_0)) {
            return VectorEncoderDecoder.decodeMagnitude(indexVersion, vectorBR);
        }
        return VectorEncoderDecoder.calculateMagnitude(indexVersion, vectorBR);
    }

    public static void decodeDenseVector(BytesRef vectorBR, float[] vector) {
        if (vectorBR == null) {
            throw new IllegalArgumentException("A document doesn't have a value for a vector field!");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(vectorBR.bytes, vectorBR.offset, vectorBR.length);
        for (int dim = 0; dim < vector.length; ++dim) {
            vector[dim] = byteBuffer.getFloat();
        }
    }
}

