/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class CoordinatorRewriteContextProvider {
    private final XContentParserConfiguration parserConfig;
    private final NamedWriteableRegistry writeableRegistry;
    private final Client client;
    private final LongSupplier nowInMillis;
    private final Supplier<ClusterState> clusterStateSupplier;
    private final Function<Index, DateFieldMapper.DateFieldType> mappingSupplier;

    public CoordinatorRewriteContextProvider(XContentParserConfiguration parserConfig, NamedWriteableRegistry writeableRegistry, Client client, LongSupplier nowInMillis, Supplier<ClusterState> clusterStateSupplier, Function<Index, DateFieldMapper.DateFieldType> mappingSupplier) {
        this.parserConfig = parserConfig;
        this.writeableRegistry = writeableRegistry;
        this.client = client;
        this.nowInMillis = nowInMillis;
        this.clusterStateSupplier = clusterStateSupplier;
        this.mappingSupplier = mappingSupplier;
    }

    @Nullable
    public CoordinatorRewriteContext getCoordinatorRewriteContext(Index index) {
        ClusterState clusterState = this.clusterStateSupplier.get();
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            return null;
        }
        IndexLongFieldRange timestampRange = indexMetadata.getTimestampRange();
        if (!timestampRange.containsAllShardRanges() && (timestampRange = indexMetadata.getTimeSeriesTimestampRange()) == null) {
            return null;
        }
        DateFieldMapper.DateFieldType dateFieldType = this.mappingSupplier.apply(index);
        if (dateFieldType == null) {
            return null;
        }
        return new CoordinatorRewriteContext(this.parserConfig, this.writeableRegistry, this.client, this.nowInMillis, timestampRange, dateFieldType);
    }
}

