/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.indices.TermsLookup;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TermsQueryBuilder
extends AbstractQueryBuilder<TermsQueryBuilder> {
    public static final String NAME = "terms";
    private static final TransportVersion VERSION_STORE_VALUES_AS_BYTES_REFERENCE = TransportVersion.V_7_12_0;
    private final String fieldName;
    private final Values values;
    private final TermsLookup termsLookup;
    private final Supplier<List<?>> supplier;

    public TermsQueryBuilder(String fieldName, TermsLookup termsLookup) {
        this(fieldName, null, termsLookup);
    }

    private TermsQueryBuilder(String fieldName, List<Object> values, TermsLookup termsLookup) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name cannot be null.");
        }
        if (values == null && termsLookup == null) {
            throw new IllegalArgumentException("No value or termsLookup specified for terms query");
        }
        if (values != null && termsLookup != null) {
            throw new IllegalArgumentException("Both values and termsLookup specified for terms query");
        }
        this.fieldName = fieldName;
        this.values = values == null ? null : new BinaryValues(values, false);
        this.termsLookup = termsLookup;
        this.supplier = null;
    }

    public TermsQueryBuilder(String fieldName, String ... values) {
        this(fieldName, values != null ? Arrays.asList(values) : null);
    }

    public TermsQueryBuilder(String fieldName, int ... values) {
        this(fieldName, values != null ? Arrays.stream(values).mapToObj(s -> s).toList() : (List<Integer>)null);
    }

    public TermsQueryBuilder(String fieldName, long ... values) {
        this(fieldName, values != null ? Arrays.stream(values).mapToObj(s -> s).toList() : (List<Long>)null);
    }

    public TermsQueryBuilder(String fieldName, float ... values) {
        this(fieldName, values != null ? IntStream.range(0, values.length).mapToObj(i -> Float.valueOf(values[i])).toList() : (List<Float>)null);
    }

    public TermsQueryBuilder(String fieldName, double ... values) {
        this(fieldName, values != null ? Arrays.stream(values).mapToObj(s -> s).toList() : (List<Double>)null);
    }

    public TermsQueryBuilder(String fieldName, Object ... values) {
        this(fieldName, values != null ? Arrays.asList(values) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, Iterable<?> values) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name cannot be null.");
        }
        if (values == null) {
            throw new IllegalArgumentException("No value specified for terms query");
        }
        this.fieldName = fieldName;
        this.values = values instanceof Values ? (Values)values : new BinaryValues(values, true);
        this.termsLookup = null;
        this.supplier = null;
    }

    private TermsQueryBuilder(String fieldName, Supplier<List<?>> supplier) {
        this.fieldName = fieldName;
        this.values = null;
        this.termsLookup = null;
        this.supplier = supplier;
    }

    public TermsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.termsLookup = in.readOptionalWriteable(TermsLookup::new);
        this.values = Values.readFrom(in);
        this.supplier = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.supplier != null) {
            throw new IllegalStateException("supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeString(this.fieldName);
        out.writeOptionalWriteable(this.termsLookup);
        Values.writeTo(out, this.values);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Values getValues() {
        return this.values;
    }

    public List<Object> values() {
        ArrayList<Object> readableValues = new ArrayList<Object>();
        for (Object value : this.values) {
            readableValues.add(AbstractQueryBuilder.maybeConvertToString(value));
        }
        return readableValues;
    }

    public TermsLookup termsLookup() {
        return this.termsLookup;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.termsLookup != null) {
            builder.startObject(this.fieldName);
            this.termsLookup.toXContent(builder, params);
            builder.endObject();
        } else {
            builder.field(this.fieldName, this.values());
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static TermsQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        List<Object> values = null;
        TermsLookup termsLookup = null;
        String queryName = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (fieldName != null) {
                    throw new ParsingException(parser.getTokenLocation(), "[terms] query does not support multiple fields", new Object[0]);
                }
                fieldName = currentFieldName;
                values = TermsQueryBuilder.parseValues(parser);
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (fieldName != null) {
                    throw new ParsingException(parser.getTokenLocation(), "[terms] query does not support more than one field. Already got: [" + fieldName + "] but also found [" + currentFieldName + "]", new Object[0]);
                }
                fieldName = currentFieldName;
                termsLookup = TermsLookup.parseTermsLookup(parser);
                continue;
            }
            if (token.isValue()) {
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[terms] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[terms] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (fieldName == null) {
            throw new ParsingException(parser.getTokenLocation(), "[terms] query requires a field name, followed by array of terms or a document lookup specification", new Object[0]);
        }
        TermsQueryBuilder builder = (TermsQueryBuilder)((TermsQueryBuilder)new TermsQueryBuilder(fieldName, values, termsLookup).boost(boost)).queryName(queryName);
        return builder;
    }

    static List<Object> parseValues(XContentParser parser) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            Object value = TermsQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
            if (value == null) {
                throw new ParsingException(parser.getTokenLocation(), "No value specified for terms query", new Object[0]);
            }
            values.add(value);
        }
        return values;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        if (this.termsLookup != null || this.supplier != null || this.values == null || this.values.isEmpty()) {
            throw new UnsupportedOperationException("query must be rewritten first");
        }
        int maxTermsCount = context.getIndexSettings().getMaxTermsCount();
        if (this.values.size() > maxTermsCount) {
            throw new IllegalArgumentException("The number of terms [" + this.values.size() + "] used in the Terms Query request has exceeded the allowed maximum of [" + maxTermsCount + "]. This maximum can be set by changing the [" + IndexSettings.MAX_TERMS_COUNT_SETTING.getKey() + "] index level setting.");
        }
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            throw new IllegalStateException("Rewrite first");
        }
        return fieldType.termsQuery(this.values, context);
    }

    private static void fetch(TermsLookup termsLookup, Client client, ActionListener<List<Object>> actionListener) {
        GetRequest getRequest = new GetRequest(termsLookup.index(), termsLookup.id());
        getRequest.preference("_local").routing(termsLookup.routing());
        client.get(getRequest, actionListener.map(getResponse -> {
            ArrayList<Object> terms = new ArrayList<Object>();
            if (!getResponse.isSourceEmpty()) {
                List<Object> extractedValues = XContentMapValues.extractRawValues(termsLookup.path(), getResponse.getSourceAsMap());
                terms.addAll(extractedValues);
            }
            return terms;
        }));
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.values, this.termsLookup, this.supplier);
    }

    @Override
    protected boolean doEquals(TermsQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.values, other.values) && Objects.equals(this.termsLookup, other.termsLookup) && Objects.equals(this.supplier, other.supplier);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) {
        if (this.supplier != null) {
            return this.supplier.get() == null ? this : new TermsQueryBuilder(this.fieldName, (Iterable)this.supplier.get());
        }
        if (this.termsLookup != null) {
            SetOnce supplier = new SetOnce();
            queryRewriteContext.registerAsyncAction((client, listener) -> TermsQueryBuilder.fetch(this.termsLookup, client, listener.map(list -> {
                supplier.set(list);
                return null;
            })));
            return new TermsQueryBuilder(this.fieldName, () -> ((SetOnce)supplier).get());
        }
        if (this.values == null || this.values.isEmpty()) {
            return new MatchNoneQueryBuilder();
        }
        SearchExecutionContext context = queryRewriteContext.convertToSearchExecutionContext();
        if (context != null) {
            MappedFieldType fieldType = context.getFieldType(this.fieldName);
            if (fieldType == null) {
                return new MatchNoneQueryBuilder();
            }
            if (fieldType instanceof ConstantFieldType) {
                Query query = fieldType.termsQuery(this.values, context);
                if (query instanceof MatchAllDocsQuery) {
                    return new MatchAllQueryBuilder();
                }
                if (query instanceof MatchNoDocsQuery) {
                    return new MatchNoneQueryBuilder();
                }
                assert (false) : "Constant fields must produce match-all or match-none queries, got " + query;
            }
        }
        return this;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.ZERO;
    }

    private static class BinaryValues
    extends Values {
        private final BytesReference valueRef;
        private final int size;

        private BinaryValues(StreamInput in) throws IOException {
            this(in.readBytesReference());
        }

        private BinaryValues(Iterable<?> values, boolean convert) {
            this(BinaryValues.serialize(values, convert));
        }

        private BinaryValues(BytesReference bytesRef) {
            this.valueRef = bytesRef;
            try (StreamInput in = this.valueRef.streamInput();){
                this.size = BinaryValues.consumerHeadersAndGetListSize(in);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator iterator() {
            return new Iterator<Object>(){
                private final StreamInput in;
                private int pos = 0;
                {
                    try {
                        this.in = valueRef.streamInput();
                        BinaryValues.consumerHeadersAndGetListSize(this.in);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("failed to deserialize TermsQueryBuilder", e);
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.pos < size;
                }

                @Override
                public Object next() {
                    try {
                        ++this.pos;
                        return this.in.readGenericValue();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("failed to deserialize TermsQueryBuilder", e);
                    }
                }
            };
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(VERSION_STORE_VALUES_AS_BYTES_REFERENCE)) {
                out.writeBytesReference(this.valueRef);
            } else {
                this.valueRef.writeTo(out);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BinaryValues that = (BinaryValues)o;
            return Objects.equals(this.valueRef, that.valueRef);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.valueRef);
        }

        private static int consumerHeadersAndGetListSize(StreamInput in) throws IOException {
            byte genericSign = in.readByte();
            assert (genericSign == 7);
            return in.readVInt();
        }
    }

    private static abstract class Values
    extends AbstractCollection
    implements Writeable {
        private Values() {
        }

        private static Values readFrom(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter(VERSION_STORE_VALUES_AS_BYTES_REFERENCE)) {
                return in.readOptionalWriteable(BinaryValues::new);
            }
            List list = (List)in.readGenericValue();
            return list == null ? null : new ListValues(list);
        }

        private static void writeTo(StreamOutput out, Values values) throws IOException {
            if (out.getTransportVersion().onOrAfter(VERSION_STORE_VALUES_AS_BYTES_REFERENCE)) {
                out.writeOptionalWriteable(values);
            } else if (values == null) {
                out.writeGenericValue(null);
            } else {
                values.writeTo(out);
            }
        }

        protected static BytesReference serialize(Iterable<?> values, boolean convert) {
            List<Object> list;
            if (values instanceof List) {
                list = (ArrayList)values;
            } else {
                ArrayList arrayList = new ArrayList();
                for (Object o : values) {
                    arrayList.add(o);
                }
                list = arrayList;
            }
            BytesStreamOutput output = new BytesStreamOutput();
            try {
                if (convert) {
                    list = list.stream().map(AbstractQueryBuilder::maybeConvertToBytesRef).toList();
                }
                output.writeGenericValue(list);
                BytesReference bytesReference = output.bytes();
                output.close();
                return bytesReference;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        output.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("failed to serialize TermsQueryBuilder", e);
                }
            }
        }

        @Override
        public final boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean containsAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ListValues
    extends Values {
        private final List<?> values;

        private ListValues(List<?> values) throws IOException {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.values.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.values.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.values.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.values.toArray(a);
        }

        @Override
        public Object[] toArray(IntFunction generator) {
            return this.values.toArray(generator);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(VERSION_STORE_VALUES_AS_BYTES_REFERENCE)) {
                BytesReference bytesRef = ListValues.serialize(this.values, false);
                out.writeBytesReference(bytesRef);
            } else {
                out.writeGenericValue(this.values);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListValues that = (ListValues)o;
            return Objects.equals(this.values, that.values);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.values);
        }
    }
}

