/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.NamedRegistry;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.HunspellTokenFilterFactory;
import org.elasticsearch.index.analysis.KeywordAnalyzerProvider;
import org.elasticsearch.index.analysis.LowercaseNormalizerProvider;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.elasticsearch.index.analysis.PreConfiguredCharFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenizer;
import org.elasticsearch.index.analysis.ShingleTokenFilterFactory;
import org.elasticsearch.index.analysis.SimpleAnalyzerProvider;
import org.elasticsearch.index.analysis.StandardAnalyzerProvider;
import org.elasticsearch.index.analysis.StandardTokenizerFactory;
import org.elasticsearch.index.analysis.StopAnalyzerProvider;
import org.elasticsearch.index.analysis.StopTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.analysis.WhitespaceAnalyzerProvider;
import org.elasticsearch.indices.analysis.HunspellService;
import org.elasticsearch.indices.analysis.PreBuiltTokenizers;
import org.elasticsearch.indices.analysis.wrappers.StableApiWrappers;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.scanners.StablePluginsRegistry;

public final class AnalysisModule {
    private static final IndexSettings NA_INDEX_SETTINGS;
    private static final DeprecationLogger deprecationLogger;
    private final HunspellService hunspellService;
    private final AnalysisRegistry analysisRegistry;

    public AnalysisModule(Environment environment, List<AnalysisPlugin> plugins, StablePluginsRegistry stablePluginRegistry) throws IOException {
        NamedRegistry<AnalysisProvider<CharFilterFactory>> charFilters = AnalysisModule.setupCharFilters(plugins, stablePluginRegistry);
        NamedRegistry<Dictionary> hunspellDictionaries = AnalysisModule.setupHunspellDictionaries(plugins);
        this.hunspellService = new HunspellService(environment.settings(), environment, hunspellDictionaries.getRegistry());
        NamedRegistry<AnalysisProvider<TokenFilterFactory>> tokenFilters = AnalysisModule.setupTokenFilters(plugins, this.hunspellService, stablePluginRegistry);
        NamedRegistry<AnalysisProvider<TokenizerFactory>> tokenizers = AnalysisModule.setupTokenizers(plugins, stablePluginRegistry);
        NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> analyzers = AnalysisModule.setupAnalyzers(plugins, stablePluginRegistry);
        NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> normalizers = AnalysisModule.setupNormalizers(plugins);
        Map<String, PreConfiguredCharFilter> preConfiguredCharFilters = AnalysisModule.setupPreConfiguredCharFilters(plugins);
        Map<String, PreConfiguredTokenFilter> preConfiguredTokenFilters = AnalysisModule.setupPreConfiguredTokenFilters(plugins);
        Map<String, PreConfiguredTokenizer> preConfiguredTokenizers = AnalysisModule.setupPreConfiguredTokenizers(plugins);
        Map<String, PreBuiltAnalyzerProviderFactory> preConfiguredAnalyzers = AnalysisModule.setupPreBuiltAnalyzerProviderFactories(plugins);
        this.analysisRegistry = new AnalysisRegistry(environment, charFilters.getRegistry(), tokenFilters.getRegistry(), tokenizers.getRegistry(), analyzers.getRegistry(), normalizers.getRegistry(), preConfiguredCharFilters, preConfiguredTokenFilters, preConfiguredTokenizers, preConfiguredAnalyzers);
    }

    HunspellService getHunspellService() {
        return this.hunspellService;
    }

    public AnalysisRegistry getAnalysisRegistry() {
        return this.analysisRegistry;
    }

    private static NamedRegistry<AnalysisProvider<CharFilterFactory>> setupCharFilters(List<AnalysisPlugin> plugins, StablePluginsRegistry stablePluginRegistry) {
        NamedRegistry<AnalysisProvider<CharFilterFactory>> charFilters = new NamedRegistry<AnalysisProvider<CharFilterFactory>>("char_filter");
        charFilters.extractAndRegister(plugins, AnalysisPlugin::getCharFilters);
        charFilters.register(StableApiWrappers.oldApiForStableCharFilterFactory(stablePluginRegistry));
        return charFilters;
    }

    public static NamedRegistry<Dictionary> setupHunspellDictionaries(List<AnalysisPlugin> plugins) {
        NamedRegistry<Dictionary> hunspellDictionaries = new NamedRegistry<Dictionary>("dictionary");
        hunspellDictionaries.extractAndRegister(plugins, AnalysisPlugin::getHunspellDictionaries);
        return hunspellDictionaries;
    }

    private static NamedRegistry<AnalysisProvider<TokenFilterFactory>> setupTokenFilters(List<AnalysisPlugin> plugins, HunspellService hunspellService, StablePluginsRegistry stablePluginRegistry) {
        NamedRegistry<AnalysisProvider<TokenFilterFactory>> tokenFilters = new NamedRegistry<AnalysisProvider<TokenFilterFactory>>("token_filter");
        tokenFilters.register("stop", StopTokenFilterFactory::new);
        tokenFilters.register("standard", new AnalysisProvider<TokenFilterFactory>(){

            @Override
            public TokenFilterFactory get(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
                if (!indexSettings.getIndexVersionCreated().before(Version.V_7_0_0)) {
                    throw new IllegalArgumentException("The [standard] token filter has been removed.");
                }
                deprecationLogger.warn(DeprecationCategory.ANALYSIS, "standard_deprecation", "The [standard] token filter name is deprecated and will be removed in a future version.", new Object[0]);
                return new AbstractTokenFilterFactory(name, settings){

                    @Override
                    public TokenStream create(TokenStream tokenStream) {
                        return tokenStream;
                    }
                };
            }

            @Override
            public boolean requiresAnalysisSettings() {
                return false;
            }
        });
        tokenFilters.register("shingle", ShingleTokenFilterFactory::new);
        tokenFilters.register("hunspell", AnalysisPlugin.requiresAnalysisSettings((indexSettings, env, name, settings) -> new HunspellTokenFilterFactory(indexSettings, name, settings, hunspellService)));
        tokenFilters.extractAndRegister(plugins, AnalysisPlugin::getTokenFilters);
        tokenFilters.register(StableApiWrappers.oldApiForTokenFilterFactory(stablePluginRegistry));
        return tokenFilters;
    }

    static Map<String, PreBuiltAnalyzerProviderFactory> setupPreBuiltAnalyzerProviderFactories(List<AnalysisPlugin> plugins) {
        NamedRegistry<PreBuiltAnalyzerProviderFactory> preConfiguredCharFilters = new NamedRegistry<PreBuiltAnalyzerProviderFactory>("pre-built analyzer");
        for (AnalysisPlugin plugin : plugins) {
            for (PreBuiltAnalyzerProviderFactory factory : plugin.getPreBuiltAnalyzerProviderFactories()) {
                preConfiguredCharFilters.register(factory.getName(), factory);
            }
        }
        return Collections.unmodifiableMap(preConfiguredCharFilters.getRegistry());
    }

    static Map<String, PreConfiguredCharFilter> setupPreConfiguredCharFilters(List<AnalysisPlugin> plugins) {
        NamedRegistry<PreConfiguredCharFilter> preConfiguredCharFilters = new NamedRegistry<PreConfiguredCharFilter>("pre-configured char_filter");
        for (AnalysisPlugin plugin : plugins) {
            for (PreConfiguredCharFilter filter : plugin.getPreConfiguredCharFilters()) {
                preConfiguredCharFilters.register(filter.getName(), filter);
            }
        }
        return Collections.unmodifiableMap(preConfiguredCharFilters.getRegistry());
    }

    static Map<String, PreConfiguredTokenFilter> setupPreConfiguredTokenFilters(List<AnalysisPlugin> plugins) {
        NamedRegistry<PreConfiguredTokenFilter> preConfiguredTokenFilters = new NamedRegistry<PreConfiguredTokenFilter>("pre-configured token_filter");
        preConfiguredTokenFilters.register("lowercase", PreConfiguredTokenFilter.singleton("lowercase", true, LowerCaseFilter::new));
        preConfiguredTokenFilters.register("standard", PreConfiguredTokenFilter.elasticsearchVersion("standard", true, (reader, version) -> {
            if (!version.before(Version.V_7_6_0)) {
                throw new IllegalArgumentException("The [standard] token filter has been removed.");
            }
            deprecationLogger.warn(DeprecationCategory.ANALYSIS, "standard_deprecation", "The [standard] token filter is deprecated and will be removed in a future version.", new Object[0]);
            return reader;
        }));
        for (AnalysisPlugin plugin : plugins) {
            for (PreConfiguredTokenFilter filter : plugin.getPreConfiguredTokenFilters()) {
                preConfiguredTokenFilters.register(filter.getName(), filter);
            }
        }
        return Collections.unmodifiableMap(preConfiguredTokenFilters.getRegistry());
    }

    static Map<String, PreConfiguredTokenizer> setupPreConfiguredTokenizers(List<AnalysisPlugin> plugins) {
        NamedRegistry<PreConfiguredTokenizer> preConfiguredTokenizers = new NamedRegistry<PreConfiguredTokenizer>("pre-configured tokenizer");
        for (PreBuiltTokenizers preBuiltTokenizers : PreBuiltTokenizers.values()) {
            String name = preBuiltTokenizers.name().toLowerCase(Locale.ROOT);
            switch (preBuiltTokenizers.getCachingStrategy()) {
                case ONE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Caching strategy unsupported by temporary shim [" + preBuiltTokenizers + "]");
                }
            }
            PreConfiguredTokenizer preConfigured = PreConfiguredTokenizer.singleton(name, () -> preBuiltTokenizers.create(Version.CURRENT));
            preConfiguredTokenizers.register(name, preConfigured);
        }
        for (AnalysisPlugin plugin : plugins) {
            for (PreConfiguredTokenizer preConfiguredTokenizer : plugin.getPreConfiguredTokenizers()) {
                preConfiguredTokenizers.register(preConfiguredTokenizer.getName(), preConfiguredTokenizer);
            }
        }
        return Collections.unmodifiableMap(preConfiguredTokenizers.getRegistry());
    }

    private static NamedRegistry<AnalysisProvider<TokenizerFactory>> setupTokenizers(List<AnalysisPlugin> plugins, StablePluginsRegistry stablePluginRegistry) {
        NamedRegistry<AnalysisProvider<TokenizerFactory>> tokenizers = new NamedRegistry<AnalysisProvider<TokenizerFactory>>("tokenizer");
        tokenizers.register("standard", StandardTokenizerFactory::new);
        tokenizers.extractAndRegister(plugins, AnalysisPlugin::getTokenizers);
        tokenizers.register(StableApiWrappers.oldApiForTokenizerFactory(stablePluginRegistry));
        return tokenizers;
    }

    private static NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> setupAnalyzers(List<AnalysisPlugin> plugins, StablePluginsRegistry stablePluginRegistry) {
        NamedRegistry analyzers = new NamedRegistry("analyzer");
        analyzers.register("default", StandardAnalyzerProvider::new);
        analyzers.register("standard", StandardAnalyzerProvider::new);
        analyzers.register("simple", SimpleAnalyzerProvider::new);
        analyzers.register("stop", StopAnalyzerProvider::new);
        analyzers.register("whitespace", WhitespaceAnalyzerProvider::new);
        analyzers.register("keyword", KeywordAnalyzerProvider::new);
        analyzers.extractAndRegister(plugins, AnalysisPlugin::getAnalyzers);
        analyzers.register(StableApiWrappers.oldApiForAnalyzerFactory(stablePluginRegistry));
        return analyzers;
    }

    private static NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> setupNormalizers(List<AnalysisPlugin> plugins) {
        NamedRegistry normalizers = new NamedRegistry("normalizer");
        normalizers.register("lowercase", LowercaseNormalizerProvider::new);
        return normalizers;
    }

    static {
        Settings build = Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 1).put("index.number_of_shards", 1).build();
        IndexMetadata metadata = IndexMetadata.builder("_na_").settings(build).build();
        NA_INDEX_SETTINGS = new IndexSettings(metadata, Settings.EMPTY);
        deprecationLogger = DeprecationLogger.getLogger(AnalysisModule.class);
    }

    public static interface AnalysisProvider<T> {
        public T get(IndexSettings var1, Environment var2, String var3, Settings var4) throws IOException;

        default public T get(Environment environment, String name) throws IOException {
            if (this.requiresAnalysisSettings()) {
                throw new IllegalArgumentException("Analysis settings required - can't instantiate analysis factory");
            }
            return this.get(NA_INDEX_SETTINGS, environment, name, NA_INDEX_SETTINGS.getSettings());
        }

        default public boolean requiresAnalysisSettings() {
            return false;
        }
    }
}

