/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.RateLimiter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.shard.StoreRecovery;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.PeerRecoveryNotFound;
import org.elasticsearch.indices.recovery.RecoveriesCollection;
import org.elasticsearch.indices.recovery.RecoveryCleanFilesRequest;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryFileChunkRequest;
import org.elasticsearch.indices.recovery.RecoveryFilesInfoRequest;
import org.elasticsearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.elasticsearch.indices.recovery.RecoveryHandoffPrimaryContextRequest;
import org.elasticsearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySnapshotFileRequest;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsResponse;
import org.elasticsearch.indices.recovery.RecoveryTransportRequest;
import org.elasticsearch.indices.recovery.ReestablishRecoveryRequest;
import org.elasticsearch.indices.recovery.SnapshotFilesProvider;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class PeerRecoveryTargetService
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(PeerRecoveryTargetService.class);
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final RecoverySettings recoverySettings;
    private final ClusterService clusterService;
    private final SnapshotFilesProvider snapshotFilesProvider;
    private final RecoveriesCollection onGoingRecoveries;

    public PeerRecoveryTargetService(ThreadPool threadPool, TransportService transportService, RecoverySettings recoverySettings, ClusterService clusterService, SnapshotFilesProvider snapshotFilesProvider) {
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.recoverySettings = recoverySettings;
        this.clusterService = clusterService;
        this.snapshotFilesProvider = snapshotFilesProvider;
        this.onGoingRecoveries = new RecoveriesCollection(logger, threadPool);
        transportService.registerRequestHandler("internal:index/shard/recovery/filesInfo", "generic", RecoveryFilesInfoRequest::new, new FilesInfoRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/restore_file_from_snapshot", "generic", RecoverySnapshotFileRequest::new, new RestoreFileFromSnapshotTransportRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/file_chunk", "generic", RecoveryFileChunkRequest::new, new FileChunkTransportRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/clean_files", "generic", RecoveryCleanFilesRequest::new, new CleanFilesRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/prepare_translog", "generic", RecoveryPrepareForTranslogOperationsRequest::new, new PrepareForTranslogOperationsRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/translog_ops", "generic", RecoveryTranslogOperationsRequest::new, new TranslogOperationsRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/finalize", "generic", RecoveryFinalizeRecoveryRequest::new, new FinalizeRecoveryRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/handoff_primary_context", "generic", RecoveryHandoffPrimaryContextRequest::new, new HandoffPrimaryContextRequestHandler());
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        if (indexShard != null) {
            this.onGoingRecoveries.cancelRecoveriesForShard(shardId, "shard closed");
        }
    }

    public void startRecovery(IndexShard indexShard, DiscoveryNode sourceNode, RecoveryListener listener) {
        Releasable snapshotFileDownloadsPermit = this.tryAcquireSnapshotDownloadPermits();
        long recoveryId = this.onGoingRecoveries.startRecovery(indexShard, sourceNode, this.snapshotFilesProvider, listener, this.recoverySettings.activityTimeout(), snapshotFileDownloadsPermit);
        this.threadPool.generic().execute(new RecoveryRunner(recoveryId));
    }

    protected void retryRecovery(long recoveryId, Throwable reason, TimeValue retryAfter, TimeValue activityTimeout) {
        logger.trace(() -> Strings.format((String)"will retry recovery with id [%s] in [%s]", (Object[])new Object[]{recoveryId, retryAfter}), reason);
        this.retryRecovery(recoveryId, retryAfter, activityTimeout);
    }

    protected void retryRecovery(long recoveryId, String reason, TimeValue retryAfter, TimeValue activityTimeout) {
        logger.trace("will retry recovery with id [{}] in [{}] (reason [{}])", (Object)recoveryId, (Object)retryAfter, (Object)reason);
        this.retryRecovery(recoveryId, retryAfter, activityTimeout);
    }

    private void retryRecovery(long recoveryId, TimeValue retryAfter, TimeValue activityTimeout) {
        RecoveryTarget newTarget = this.onGoingRecoveries.resetRecovery(recoveryId, activityTimeout);
        if (newTarget != null) {
            this.threadPool.scheduleUnlessShuttingDown(retryAfter, "generic", new RecoveryRunner(newTarget.recoveryId()));
        }
    }

    protected void reestablishRecovery(StartRecoveryRequest request, String reason, TimeValue retryAfter) {
        long recoveryId = request.recoveryId();
        logger.trace("will try to reestablish recovery with id [{}] in [{}] (reason [{}])", (Object)recoveryId, (Object)retryAfter, (Object)reason);
        this.threadPool.scheduleUnlessShuttingDown(retryAfter, "generic", new RecoveryRunner(recoveryId, request));
    }

    private void doRecovery(long recoveryId, StartRecoveryRequest preExistingRequest) {
        record StartRecoveryRequestToSend(StartRecoveryRequest startRecoveryRequest, String actionName, TransportRequest requestToSend) {
        }
        RecoveriesCollection.RecoveryRef recoveryRef = this.onGoingRecoveries.getRecovery(recoveryId);
        if (recoveryRef == null) {
            logger.trace("not running recovery with id [{}] - can not find it (probably finished)", (Object)recoveryId);
            return;
        }
        RecoveryTarget recoveryTarget = recoveryRef.target();
        assert (recoveryTarget.sourceNode() != null) : "cannot do a recovery without a source node";
        RecoveryState recoveryState = recoveryTarget.state();
        RecoveryState.Timer timer = recoveryState.getTimer();
        IndexShard indexShard = recoveryTarget.indexShard();
        Releasable onCompletion = Releasables.wrap((Releasable[])new Releasable[]{recoveryTarget.disableRecoveryMonitor(), recoveryRef});
        ActionListener cleanupOnly = ActionListener.notifyOnce(ActionListener.runBefore(ActionListener.noop().delegateResponse((l, e) -> {
            logger.trace("unexpected error while preparing shard for peer recovery, failing recovery", (Throwable)e);
            this.onGoingRecoveries.failRecovery(recoveryId, new RecoveryFailedException(recoveryTarget.state(), "failed to prepare shard for recovery", (Throwable)e), true);
        }), () -> ((Releasable)onCompletion).close()));
        if (!indexShard.routingEntry().isPromotableToPrimary()) {
            assert (preExistingRequest == null);
            assert (!indexShard.indexSettings().getIndexMetadata().isSearchableSnapshot());
            ActionListener.run(cleanupOnly.map(v -> {
                logger.trace("{} preparing shard for peer recovery", (Object)recoveryTarget.shardId());
                indexShard.prepareForIndexRecovery();
                recoveryState.setStage(RecoveryState.Stage.VERIFY_INDEX);
                recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
                indexShard.openEngineAndSkipTranslogRecovery();
                recoveryState.getIndex().setFileDetailsComplete();
                recoveryState.setStage(RecoveryState.Stage.FINALIZE);
                this.onGoingRecoveries.markRecoveryAsDone(recoveryId);
                return null;
            }), indexShard::preRecovery);
            return;
        }
        ActionListener toSendListener = cleanupOnly.map(r -> {
            logger.trace("{} [{}]: recovery from {}", (Object)r.startRecoveryRequest().shardId(), (Object)r.actionName(), (Object)r.startRecoveryRequest().sourceNode());
            this.transportService.sendRequest(r.startRecoveryRequest().sourceNode(), r.actionName(), r.requestToSend(), new RecoveryResponseHandler(r.startRecoveryRequest(), timer));
            return null;
        });
        if (preExistingRequest == null) {
            ActionListener.run(toSendListener.map(v -> {
                logger.trace("{} preparing shard for peer recovery", (Object)recoveryTarget.shardId());
                indexShard.prepareForIndexRecovery();
                if (indexShard.indexSettings().getIndexMetadata().isSearchableSnapshot()) {
                    indexShard.getIndexEventListener().afterFilesRestoredFromRepository(indexShard);
                    Store store = indexShard.store();
                    store.incRef();
                    try {
                        StoreRecovery.bootstrap(indexShard, store);
                    }
                    finally {
                        store.decRef();
                    }
                }
                long startingSeqNo = indexShard.recoverLocallyUpToGlobalCheckpoint();
                assert (startingSeqNo == -2L || recoveryTarget.state().getStage() == RecoveryState.Stage.TRANSLOG) : "unexpected recovery stage [" + recoveryTarget.state().getStage() + "] starting seqno [ " + startingSeqNo + "]";
                StartRecoveryRequest startRequest = PeerRecoveryTargetService.getStartRecoveryRequest(logger, this.clusterService.localNode(), recoveryTarget, startingSeqNo);
                return new StartRecoveryRequestToSend(startRequest, "internal:index/shard/recovery/start_recovery", startRequest);
            }), indexShard::preRecovery);
        } else {
            toSendListener.onResponse(new StartRecoveryRequestToSend(preExistingRequest, "internal:index/shard/recovery/reestablish_recovery", new ReestablishRecoveryRequest(recoveryId, preExistingRequest.shardId(), preExistingRequest.targetAllocationId())));
        }
    }

    public Releasable tryAcquireSnapshotDownloadPermits() {
        return this.recoverySettings.tryAcquireSnapshotDownloadPermits();
    }

    public static StartRecoveryRequest getStartRecoveryRequest(Logger logger, DiscoveryNode localNode, RecoveryTarget recoveryTarget, long startingSeqNo) {
        Store.MetadataSnapshot metadataSnapshot;
        block10: {
            logger.trace("{} collecting local files for [{}]", (Object)recoveryTarget.shardId(), (Object)recoveryTarget.sourceNode());
            try {
                if (recoveryTarget.indexShard().routingEntry().isPromotableToPrimary()) {
                    metadataSnapshot = recoveryTarget.indexShard().snapshotStoreMetadata();
                    try {
                        String expectedTranslogUUID = metadataSnapshot.commitUserData().get("translog_uuid");
                        long globalCheckpoint = Translog.readGlobalCheckpoint(recoveryTarget.translogLocation(), expectedTranslogUUID);
                        assert (globalCheckpoint + 1L >= startingSeqNo) : "invalid startingSeqNo " + startingSeqNo + " >= " + globalCheckpoint;
                        break block10;
                    }
                    catch (IOException | TranslogCorruptedException e) {
                        PeerRecoveryTargetService.logGlobalCheckpointWarning(logger, startingSeqNo, e);
                        metadataSnapshot = Store.MetadataSnapshot.EMPTY;
                        startingSeqNo = -2L;
                    }
                    break block10;
                }
                metadataSnapshot = Store.MetadataSnapshot.EMPTY;
                startingSeqNo = -2L;
            }
            catch (IndexNotFoundException e) {
                assert (startingSeqNo == -2L) : startingSeqNo;
                logger.trace("{} shard folder empty, recovering all files", (Object)recoveryTarget);
                metadataSnapshot = Store.MetadataSnapshot.EMPTY;
            }
            catch (IOException e) {
                if (startingSeqNo != -2L) {
                    PeerRecoveryTargetService.logListingLocalFilesWarning(logger, startingSeqNo, e);
                    startingSeqNo = -2L;
                } else {
                    logger.warn("error while listing local files, recovering as if there are none", (Throwable)e);
                }
                metadataSnapshot = Store.MetadataSnapshot.EMPTY;
            }
        }
        logger.trace("{} local file count [{}]", (Object)recoveryTarget.shardId(), (Object)metadataSnapshot.size());
        StartRecoveryRequest request = new StartRecoveryRequest(recoveryTarget.shardId(), recoveryTarget.indexShard().routingEntry().allocationId().getId(), recoveryTarget.sourceNode(), localNode, metadataSnapshot, recoveryTarget.state().getPrimary(), recoveryTarget.recoveryId(), startingSeqNo, recoveryTarget.hasPermitToDownloadSnapshotFiles());
        return request;
    }

    private static void logListingLocalFilesWarning(Logger logger, long startingSeqNo, IOException e) {
        logger.warn(() -> Strings.format((String)"error while listing local files, resetting the starting sequence number from %s to unassigned and recovering as if there are none", (Object[])new Object[]{startingSeqNo}), (Throwable)e);
    }

    private static void logGlobalCheckpointWarning(Logger logger, long startingSeqNo, Exception e) {
        logger.warn(() -> Strings.format((String)"error while reading global checkpoint from translog, resetting the starting sequence number from %s to unassigned and recovering as if there are none", (Object[])new Object[]{startingSeqNo}), (Throwable)e);
    }

    private static ActionListener<Void> createOrFinishListener(RecoveriesCollection.RecoveryRef recoveryRef, TransportChannel channel, String action, RecoveryTransportRequest request) {
        return PeerRecoveryTargetService.createOrFinishListener(recoveryRef, channel, action, request, (CheckedFunction<Void, TransportResponse, Exception>)((CheckedFunction)nullVal -> TransportResponse.Empty.INSTANCE));
    }

    @Nullable
    private static ActionListener<Void> createOrFinishListener(RecoveriesCollection.RecoveryRef recoveryRef, TransportChannel channel, String action, RecoveryTransportRequest request, CheckedFunction<Void, TransportResponse, Exception> responseFn) {
        RecoveryTarget recoveryTarget = recoveryRef.target();
        ActionListener<Void> voidListener = new ChannelActionListener<TransportResponse, RecoveryTransportRequest>(channel, action, request).map(responseFn);
        long requestSeqNo = request.requestSeqNo();
        ActionListener<Void> listener = requestSeqNo != -2L ? recoveryTarget.markRequestReceivedAndCreateListener(requestSeqNo, voidListener) : voidListener;
        return listener;
    }

    public static class Actions {
        public static final String FILES_INFO = "internal:index/shard/recovery/filesInfo";
        public static final String RESTORE_FILE_FROM_SNAPSHOT = "internal:index/shard/recovery/restore_file_from_snapshot";
        public static final String FILE_CHUNK = "internal:index/shard/recovery/file_chunk";
        public static final String CLEAN_FILES = "internal:index/shard/recovery/clean_files";
        public static final String TRANSLOG_OPS = "internal:index/shard/recovery/translog_ops";
        public static final String PREPARE_TRANSLOG = "internal:index/shard/recovery/prepare_translog";
        public static final String FINALIZE = "internal:index/shard/recovery/finalize";
        public static final String HANDOFF_PRIMARY_CONTEXT = "internal:index/shard/recovery/handoff_primary_context";
    }

    class FilesInfoRequestHandler
    implements TransportRequestHandler<RecoveryFilesInfoRequest> {
        FilesInfoRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryFilesInfoRequest request, TransportChannel channel, Task task) throws Exception {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                ActionListener<Void> listener = PeerRecoveryTargetService.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/filesInfo", request);
                if (listener == null) {
                    return;
                }
                recoveryRef.target().receiveFileInfo(request.phase1FileNames, request.phase1FileSizes, request.phase1ExistingFileNames, request.phase1ExistingFileSizes, request.totalTranslogOps, listener);
            }
        }
    }

    class RestoreFileFromSnapshotTransportRequestHandler
    implements TransportRequestHandler<RecoverySnapshotFileRequest> {
        RestoreFileFromSnapshotTransportRequestHandler() {
        }

        @Override
        public void messageReceived(RecoverySnapshotFileRequest request, TransportChannel channel, Task task) throws Exception {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.getRecoveryId(), request.getShardId());){
                RecoveryTarget recoveryTarget = recoveryRef.target();
                ActionListener<Void> listener = PeerRecoveryTargetService.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/restore_file_from_snapshot", request);
                if (listener == null) {
                    return;
                }
                recoveryTarget.restoreFileFromSnapshot(request.getRepository(), request.getIndexId(), request.getFileInfo(), listener);
            }
        }
    }

    class FileChunkTransportRequestHandler
    implements TransportRequestHandler<RecoveryFileChunkRequest> {
        final AtomicLong bytesSinceLastPause = new AtomicLong();

        FileChunkTransportRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryFileChunkRequest request, TransportChannel channel, Task task) throws Exception {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                long bytes;
                RateLimiter rateLimiter;
                RecoveryTarget recoveryTarget = recoveryRef.target();
                ActionListener<Void> listener = PeerRecoveryTargetService.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/file_chunk", request);
                if (listener == null) {
                    return;
                }
                RecoveryState.Index indexState = recoveryTarget.state().getIndex();
                if (request.sourceThrottleTimeInNanos() != -1L) {
                    indexState.addSourceThrottling(request.sourceThrottleTimeInNanos());
                }
                if ((rateLimiter = PeerRecoveryTargetService.this.recoverySettings.rateLimiter()) != null && (bytes = this.bytesSinceLastPause.addAndGet(request.content().length())) > rateLimiter.getMinPauseCheckBytes()) {
                    this.bytesSinceLastPause.addAndGet(-bytes);
                    long throttleTimeInNanos = rateLimiter.pause(bytes);
                    indexState.addTargetThrottling(throttleTimeInNanos);
                    recoveryTarget.indexShard().recoveryStats().addThrottleTime(throttleTimeInNanos);
                }
                recoveryTarget.writeFileChunk(request.metadata(), request.position(), request.content(), request.lastChunk(), request.totalTranslogOps(), listener);
            }
        }
    }

    class CleanFilesRequestHandler
    implements TransportRequestHandler<RecoveryCleanFilesRequest> {
        CleanFilesRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryCleanFilesRequest request, TransportChannel channel, Task task) throws Exception {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                ActionListener<Void> listener = PeerRecoveryTargetService.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/clean_files", request);
                if (listener == null) {
                    return;
                }
                recoveryRef.target().cleanFiles(request.totalTranslogOps(), request.getGlobalCheckpoint(), request.sourceMetaSnapshot(), listener.delegateFailure((l, r) -> {
                    Releasable reenableMonitor = recoveryRef.target().disableRecoveryMonitor();
                    recoveryRef.target().indexShard().afterCleanFiles(() -> {
                        reenableMonitor.close();
                        l.onResponse(null);
                    });
                }));
            }
        }
    }

    class PrepareForTranslogOperationsRequestHandler
    implements TransportRequestHandler<RecoveryPrepareForTranslogOperationsRequest> {
        PrepareForTranslogOperationsRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryPrepareForTranslogOperationsRequest request, TransportChannel channel, Task task) {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                ActionListener<Void> listener = PeerRecoveryTargetService.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/prepare_translog", request);
                if (listener == null) {
                    return;
                }
                recoveryRef.target().prepareForTranslogOperations(request.totalTranslogOps(), listener);
            }
        }
    }

    class TranslogOperationsRequestHandler
    implements TransportRequestHandler<RecoveryTranslogOperationsRequest> {
        TranslogOperationsRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryTranslogOperationsRequest request, TransportChannel channel, Task task) throws IOException {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                RecoveryTarget recoveryTarget = recoveryRef.target();
                ActionListener<Void> listener = PeerRecoveryTargetService.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/translog_ops", request, (CheckedFunction<Void, TransportResponse, Exception>)((CheckedFunction)nullVal -> new RecoveryTranslogOperationsResponse(recoveryTarget.indexShard().getLocalCheckpoint())));
                if (listener == null) {
                    return;
                }
                this.performTranslogOps(request, listener, recoveryRef);
            }
        }

        private void performTranslogOps(final RecoveryTranslogOperationsRequest request, final ActionListener<Void> listener, RecoveriesCollection.RecoveryRef recoveryRef) {
            RecoveryTarget recoveryTarget = recoveryRef.target();
            ClusterStateObserver observer = new ClusterStateObserver(PeerRecoveryTargetService.this.clusterService, null, logger, PeerRecoveryTargetService.this.threadPool.getThreadContext());
            Consumer<Exception> retryOnMappingException = exception -> {
                logger.debug("delaying recovery due to missing mapping changes", (Throwable)exception);
                observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        PeerRecoveryTargetService.this.threadPool.generic().execute(ActionRunnable.wrap(listener, l -> {
                            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                                TranslogOperationsRequestHandler.this.performTranslogOps(request, listener, recoveryRef);
                            }
                        }));
                    }

                    @Override
                    public void onClusterServiceClose() {
                        listener.onFailure(new ElasticsearchException("cluster service was closed while waiting for mapping updates", new Object[0]));
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        listener.onFailure(new ElasticsearchTimeoutException("timed out waiting for mapping updates (timeout [" + timeout + "])", new Object[0]));
                    }
                });
            };
            IndexMetadata indexMetadata = PeerRecoveryTargetService.this.clusterService.state().metadata().index(request.shardId().getIndex());
            long mappingVersionOnTarget = indexMetadata != null ? indexMetadata.getMappingVersion() : 0L;
            recoveryTarget.indexTranslogOperations(request.operations(), request.totalTranslogOps(), request.maxSeenAutoIdTimestampOnPrimary(), request.maxSeqNoOfUpdatesOrDeletesOnPrimary(), request.retentionLeases(), request.mappingVersionOnPrimary(), ActionListener.wrap(checkpoint -> listener.onResponse(null), e -> {
                if (mappingVersionOnTarget < request.mappingVersionOnPrimary() && e instanceof MapperException) {
                    retryOnMappingException.accept((Exception)e);
                } else {
                    listener.onFailure((Exception)e);
                }
            }));
        }
    }

    class FinalizeRecoveryRequestHandler
    implements TransportRequestHandler<RecoveryFinalizeRecoveryRequest> {
        FinalizeRecoveryRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryFinalizeRecoveryRequest request, TransportChannel channel, Task task) throws Exception {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                ActionListener<Void> listener = PeerRecoveryTargetService.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/finalize", request);
                if (listener == null) {
                    return;
                }
                recoveryRef.target().finalizeRecovery(request.globalCheckpoint(), request.trimAboveSeqNo(), listener);
            }
        }
    }

    class HandoffPrimaryContextRequestHandler
    implements TransportRequestHandler<RecoveryHandoffPrimaryContextRequest> {
        HandoffPrimaryContextRequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageReceived(RecoveryHandoffPrimaryContextRequest request, TransportChannel channel, Task task) throws Exception {
            RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());
            boolean success = false;
            try {
                recoveryRef.target().handoffPrimaryContext(request.primaryContext(), ActionListener.runBefore(new ChannelActionListener(channel, "internal:index/shard/recovery/handoff_primary_context", request).map(v -> TransportResponse.Empty.INSTANCE), recoveryRef::close));
                success = true;
            }
            finally {
                if (!success) {
                    recoveryRef.close();
                }
            }
        }
    }

    public static interface RecoveryListener {
        public void onRecoveryDone(RecoveryState var1, ShardLongFieldRange var2);

        public void onRecoveryFailure(RecoveryState var1, RecoveryFailedException var2, boolean var3);
    }

    class RecoveryRunner
    extends AbstractRunnable {
        final long recoveryId;
        private final StartRecoveryRequest startRecoveryRequest;

        RecoveryRunner(long recoveryId) {
            this(recoveryId, null);
        }

        RecoveryRunner(long recoveryId, StartRecoveryRequest startRecoveryRequest) {
            this.recoveryId = recoveryId;
            this.startRecoveryRequest = startRecoveryRequest;
        }

        @Override
        public void onFailure(Exception e) {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecovery(this.recoveryId);){
                if (recoveryRef != null) {
                    logger.error(() -> "unexpected error during recovery [" + this.recoveryId + "], failing shard", (Throwable)e);
                    PeerRecoveryTargetService.this.onGoingRecoveries.failRecovery(this.recoveryId, new RecoveryFailedException(recoveryRef.target().state(), "unexpected error", (Throwable)e), true);
                } else {
                    logger.debug(() -> "unexpected error during recovery, but recovery id [" + this.recoveryId + "] is finished", (Throwable)e);
                }
            }
        }

        @Override
        public void doRun() {
            PeerRecoveryTargetService.this.doRecovery(this.recoveryId, this.startRecoveryRequest);
        }
    }

    private class RecoveryResponseHandler
    implements TransportResponseHandler<RecoveryResponse> {
        private final long recoveryId;
        private final StartRecoveryRequest request;
        private final RecoveryState.Timer timer;

        private RecoveryResponseHandler(StartRecoveryRequest request, RecoveryState.Timer timer) {
            this.recoveryId = request.recoveryId();
            this.request = request;
            this.timer = timer;
        }

        @Override
        public void handleResponse(RecoveryResponse recoveryResponse) {
            TimeValue recoveryTime = new TimeValue(this.timer.time());
            PeerRecoveryTargetService.this.onGoingRecoveries.markRecoveryAsDone(this.recoveryId);
            if (logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append('[').append(this.request.shardId().getIndex().getName()).append(']').append('[').append(this.request.shardId().id()).append("] ");
                sb.append("recovery completed from ").append(this.request.sourceNode()).append(", took[").append(recoveryTime).append("]\n");
                sb.append("   phase1: recovered_files [").append(recoveryResponse.phase1FileNames.size()).append("]").append(" with total_size of [").append(ByteSizeValue.ofBytes(recoveryResponse.phase1TotalSize)).append("]").append(", took [").append(TimeValue.timeValueMillis((long)recoveryResponse.phase1Time)).append("], throttling_wait [").append(TimeValue.timeValueMillis((long)recoveryResponse.phase1ThrottlingWaitTime)).append(']').append("\n");
                sb.append("         : reusing_files   [").append(recoveryResponse.phase1ExistingFileNames.size()).append("] with total_size of [").append(ByteSizeValue.ofBytes(recoveryResponse.phase1ExistingTotalSize)).append("]\n");
                sb.append("   phase2: start took [").append(TimeValue.timeValueMillis((long)recoveryResponse.startTime)).append("]\n");
                sb.append("         : recovered [").append(recoveryResponse.phase2Operations).append("]").append(" transaction log operations").append(", took [").append(TimeValue.timeValueMillis((long)recoveryResponse.phase2Time)).append("]").append("\n");
                logger.trace("{}", (Object)sb);
            } else {
                logger.debug("{} recovery done from [{}], took [{}]", (Object)this.request.shardId(), (Object)this.request.sourceNode(), (Object)recoveryTime);
            }
        }

        @Override
        public void handleException(TransportException e) {
            if (logger.isTraceEnabled()) {
                logger.trace(() -> Strings.format((String)"[%s][%s] Got exception on recovery", (Object[])new Object[]{this.request.shardId().getIndex().getName(), this.request.shardId().id()}), (Throwable)e);
            }
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            if (PeerRecoveryTargetService.this.transportService.lifecycleState() != Lifecycle.State.STARTED) {
                PeerRecoveryTargetService.this.onGoingRecoveries.failRecovery(this.recoveryId, new RecoveryFailedException(this.request, "node is shutting down", cause), false);
                return;
            }
            if (cause instanceof CancellableThreads.ExecutionCancelledException) {
                PeerRecoveryTargetService.this.onGoingRecoveries.failRecovery(this.recoveryId, new RecoveryFailedException(this.request, "source has canceled the recovery", cause), false);
                return;
            }
            if (cause instanceof RecoveryEngineException) {
                cause = cause.getCause();
            }
            if ((cause = ExceptionsHelper.unwrapCause(cause)) instanceof RecoveryEngineException) {
                cause = cause.getCause();
            }
            if (cause instanceof IllegalIndexShardStateException || cause instanceof org.elasticsearch.index.IndexNotFoundException || cause instanceof ShardNotFoundException) {
                PeerRecoveryTargetService.this.retryRecovery(this.recoveryId, "remote shard not ready", PeerRecoveryTargetService.this.recoverySettings.retryDelayStateSync(), PeerRecoveryTargetService.this.recoverySettings.activityTimeout());
                return;
            }
            if (cause instanceof DelayRecoveryException || cause instanceof PeerRecoveryNotFound) {
                PeerRecoveryTargetService.this.retryRecovery(this.recoveryId, cause, PeerRecoveryTargetService.this.recoverySettings.retryDelayStateSync(), PeerRecoveryTargetService.this.recoverySettings.activityTimeout());
                return;
            }
            if (cause instanceof ConnectTransportException) {
                logger.info("recovery of {} from [{}] interrupted by network disconnect, will retry in [{}]; cause: [{}]", (Object)this.request.shardId(), (Object)this.request.sourceNode(), (Object)PeerRecoveryTargetService.this.recoverySettings.retryDelayNetwork(), (Object)cause.getMessage());
                PeerRecoveryTargetService.this.reestablishRecovery(this.request, cause.getMessage(), PeerRecoveryTargetService.this.recoverySettings.retryDelayNetwork());
                return;
            }
            if (cause instanceof AlreadyClosedException) {
                PeerRecoveryTargetService.this.onGoingRecoveries.failRecovery(this.recoveryId, new RecoveryFailedException(this.request, "source shard is closed", cause), false);
                return;
            }
            PeerRecoveryTargetService.this.onGoingRecoveries.failRecovery(this.recoveryId, new RecoveryFailedException(this.request, (Throwable)e), true);
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public RecoveryResponse read(StreamInput in) throws IOException {
            return new RecoveryResponse(in);
        }
    }
}

