/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoveryTransportRequest;
import org.elasticsearch.repositories.IndexId;

public class RecoverySnapshotFileRequest
extends RecoveryTransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final String repository;
    private final IndexId indexId;
    private final BlobStoreIndexShardSnapshot.FileInfo fileInfo;

    public RecoverySnapshotFileRequest(long recoveryId, long requestSeqNo, ShardId shardId, String repository, IndexId indexId, BlobStoreIndexShardSnapshot.FileInfo fileInfo) {
        super(requestSeqNo);
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.repository = repository;
        this.indexId = indexId;
        this.fileInfo = fileInfo;
    }

    public RecoverySnapshotFileRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.repository = in.readString();
        this.indexId = new IndexId(in);
        this.fileInfo = new BlobStoreIndexShardSnapshot.FileInfo(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (out.getTransportVersion().onOrAfter(RecoverySettings.SNAPSHOT_RECOVERIES_SUPPORTED_VERSION.transportVersion)) : "Unexpected serialization version " + out.getTransportVersion();
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeString(this.repository);
        this.indexId.writeTo(out);
        this.fileInfo.writeTo(out);
    }

    public long getRecoveryId() {
        return this.recoveryId;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public String getRepository() {
        return this.repository;
    }

    public IndexId getIndexId() {
        return this.indexId;
    }

    public BlobStoreIndexShardSnapshot.FileInfo getFileInfo() {
        return this.fileInfo;
    }
}

