/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.Streams;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public interface ChunkedRestResponseBody {
    public boolean isDone();

    public ReleasableBytesReference encodeChunk(int var1, Recycler<BytesRef> var2) throws IOException;

    public String getResponseContentTypeString();

    public static ChunkedRestResponseBody fromXContent(final ChunkedToXContent chunkedToXContent, final ToXContent.Params params, final RestChannel channel) throws IOException {
        return new ChunkedRestResponseBody(){
            private final OutputStream out = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    target.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    target.write(b, off, len);
                }
            };
            private final XContentBuilder builder = channel.newBuilder(channel.request().getXContentType(), null, true, Streams.noCloseStream((OutputStream)this.out));
            private final Iterator<? extends ToXContent> serialization = this.builder.getRestApiVersion() == RestApiVersion.V_7 ? chunkedToXContent.toXContentChunkedV7(params) : chunkedToXContent.toXContentChunked(params);
            private BytesStream target;

            @Override
            public boolean isDone() {
                return !this.serialization.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ReleasableBytesReference encodeChunk(int sizeHint, Recycler<BytesRef> recycler) throws IOException {
                try {
                    RecyclerBytesStreamOutput chunkStream = new RecyclerBytesStreamOutput(recycler);
                    assert (this.target == null);
                    this.target = chunkStream;
                    while (this.serialization.hasNext()) {
                        this.serialization.next().toXContent(this.builder, params);
                        if (chunkStream.size() < sizeHint) continue;
                    }
                    if (!this.serialization.hasNext()) {
                        this.builder.close();
                    }
                    ReleasableBytesReference result = new ReleasableBytesReference(chunkStream.bytes(), () -> Releasables.closeExpectNoException((Releasable)chunkStream));
                    this.target = null;
                    ReleasableBytesReference releasableBytesReference = result;
                    return releasableBytesReference;
                }
                finally {
                    if (this.target != null) {
                        assert (false) : "failure encoding chunk";
                        IOUtils.closeWhileHandlingException((Closeable)this.target);
                        this.target = null;
                    }
                }
            }

            @Override
            public String getResponseContentTypeString() {
                return this.builder.getResponseContentTypeString();
            }
        };
    }
}

