/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.ChunkedRestResponseBody;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RestResponse {
    public static final String TEXT_CONTENT_TYPE = "text/plain; charset=UTF-8";
    private static final String STATUS = "status";
    private static final Logger SUPPRESSED_ERROR_LOGGER = LogManager.getLogger((String)"rest.suppressed");
    private final RestStatus status;
    @Nullable
    private final BytesReference content;
    @Nullable
    private final ChunkedRestResponseBody chunkedResponseBody;
    private final String responseMediaType;
    private Map<String, List<String>> customHeaders;

    public RestResponse(RestStatus status, XContentBuilder builder) {
        this(status, builder.getResponseContentTypeString(), BytesReference.bytes(builder));
    }

    public RestResponse(RestStatus status, String content) {
        this(status, TEXT_CONTENT_TYPE, new BytesArray(content));
    }

    public RestResponse(RestStatus status, String responseMediaType, String content) {
        this(status, responseMediaType, new BytesArray(content));
    }

    public RestResponse(RestStatus status, String responseMediaType, BytesReference content) {
        this(status, responseMediaType, content, null);
    }

    public RestResponse(RestStatus status, ChunkedRestResponseBody content) {
        this(status, content.getResponseContentTypeString(), null, content);
    }

    private RestResponse(RestStatus status, String responseMediaType, @Nullable BytesReference content, @Nullable ChunkedRestResponseBody chunkedResponseBody) {
        this.status = status;
        this.content = content;
        this.responseMediaType = responseMediaType;
        this.chunkedResponseBody = chunkedResponseBody;
        assert (content == null != (chunkedResponseBody == null));
    }

    public RestResponse(RestChannel channel, Exception e) throws IOException {
        this(channel, ExceptionsHelper.status(e), e);
    }

    public RestResponse(RestChannel channel, RestStatus status, Exception e) throws IOException {
        ToXContent.Params params = this.paramsFromRequest(channel.request());
        if (params.paramAsBoolean("rest.exception.stacktrace.skip", true) && e != null) {
            Supplier messageSupplier = () -> String.format(Locale.ROOT, "path: %s, params: %s", channel.request().rawPath(), channel.request().params());
            if (status.getStatus() < 500) {
                SUPPRESSED_ERROR_LOGGER.debug(messageSupplier, (Throwable)e);
            } else {
                SUPPRESSED_ERROR_LOGGER.warn(messageSupplier, (Throwable)e);
            }
        }
        this.status = status;
        try (XContentBuilder builder = channel.newErrorBuilder();){
            RestResponse.build(builder, params, status, channel.detailedErrorsEnabled(), e);
            this.content = BytesReference.bytes(builder);
            this.responseMediaType = builder.getResponseContentTypeString();
        }
        if (e instanceof ElasticsearchException) {
            this.copyHeaders((ElasticsearchException)e);
        }
        this.chunkedResponseBody = null;
    }

    public String contentType() {
        return this.responseMediaType;
    }

    @Nullable
    public BytesReference content() {
        return this.content;
    }

    @Nullable
    public ChunkedRestResponseBody chunkedContent() {
        return this.chunkedResponseBody;
    }

    public boolean isChunked() {
        return this.chunkedResponseBody != null;
    }

    public RestStatus status() {
        return this.status;
    }

    private ToXContent.Params paramsFromRequest(RestRequest restRequest) {
        RestRequest params = restRequest;
        if (params.paramAsBoolean("error_trace", false) && !this.skipStackTrace()) {
            params = new ToXContent.DelegatingMapParams(Collections.singletonMap("rest.exception.stacktrace.skip", "false"), (ToXContent.Params)params);
        }
        return params;
    }

    protected boolean skipStackTrace() {
        return false;
    }

    private static void build(XContentBuilder builder, ToXContent.Params params, RestStatus status, boolean detailedErrorsEnabled, Exception e) throws IOException {
        builder.startObject();
        ElasticsearchException.generateFailureXContent(builder, params, e, detailedErrorsEnabled);
        builder.field(STATUS, status.getStatus());
        builder.endObject();
    }

    static RestResponse createSimpleErrorResponse(RestChannel channel, RestStatus status, String errorMessage) throws IOException {
        return new RestResponse(status, channel.newErrorBuilder().startObject().field("error", errorMessage).field(STATUS, status.getStatus()).endObject());
    }

    public static ElasticsearchStatusException errorFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        Throwable exception = null;
        RestStatus status = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            }
            if (STATUS.equals(currentFieldName)) {
                if (token == XContentParser.Token.FIELD_NAME) continue;
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser);
                status = RestStatus.fromCode(parser.intValue());
                continue;
            }
            exception = ElasticsearchException.failureFromXContent(parser);
        }
        if (exception == null) {
            throw new IllegalStateException("Failed to parse elasticsearch status exception: no exception was found");
        }
        ElasticsearchStatusException result = new ElasticsearchStatusException(exception.getMessage(), status, exception.getCause(), new Object[0]);
        for (String header : ((ElasticsearchException)exception).getHeaderKeys()) {
            result.addHeader(header, ((ElasticsearchException)exception).getHeader(header));
        }
        for (String metadata : ((ElasticsearchException)exception).getMetadataKeys()) {
            result.addMetadata(metadata, ((ElasticsearchException)exception).getMetadata(metadata));
        }
        return result;
    }

    public void copyHeaders(ElasticsearchException ex) {
        Set<String> headerKeySet = ex.getHeaderKeys();
        if (this.customHeaders == null) {
            this.customHeaders = Maps.newMapWithExpectedSize(headerKeySet.size());
        }
        for (String key : headerKeySet) {
            this.customHeaders.computeIfAbsent(key, k -> new ArrayList()).addAll(ex.getHeader(key));
        }
    }

    public void addHeader(String name, String value) {
        if (this.customHeaders == null) {
            this.customHeaders = Maps.newMapWithExpectedSize(2);
        }
        this.customHeaders.computeIfAbsent(name, k -> new ArrayList()).add(value);
    }

    public Map<String, List<String>> getHeaders() {
        return Objects.requireNonNullElse(this.customHeaders, Map.of());
    }

    public Map<String, List<String>> filterHeaders(Map<String, List<String>> headers) {
        return headers;
    }
}

