/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.main.MainAction;
import org.elasticsearch.action.main.MainRequest;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestMainAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/"), new RestHandler.Route(RestRequest.Method.HEAD, "/"));
    }

    @Override
    public String getName() {
        return "main_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return channel -> client.execute(MainAction.INSTANCE, new MainRequest(), new RestBuilderListener<MainResponse>(channel){

            @Override
            public RestResponse buildResponse(MainResponse mainResponse, XContentBuilder builder) throws Exception {
                return RestMainAction.convertMainResponse(mainResponse, request, builder);
            }
        });
    }

    static RestResponse convertMainResponse(MainResponse response, RestRequest request, XContentBuilder builder) throws IOException {
        if (!request.hasParam("pretty")) {
            builder.prettyPrint().lfAtEnd();
        }
        response.toXContent(builder, request);
        return new RestResponse(RestStatus.OK, builder);
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

