/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.index.mapper.vectors.VectorEncoderDecoder;
import org.elasticsearch.script.field.vectors.DenseVector;

public class BinaryDenseVector
implements DenseVector {
    protected final BytesRef docVector;
    protected final int dims;
    protected final Version indexVersion;
    protected float[] decodedDocVector;

    public BinaryDenseVector(BytesRef docVector, int dims, Version indexVersion) {
        this.docVector = docVector;
        this.indexVersion = indexVersion;
        this.dims = dims;
    }

    @Override
    public float[] getVector() {
        if (this.decodedDocVector == null) {
            this.decodedDocVector = new float[this.dims];
            VectorEncoderDecoder.decodeDenseVector(this.docVector, this.decodedDocVector);
        }
        return this.decodedDocVector;
    }

    @Override
    public float getMagnitude() {
        return VectorEncoderDecoder.getMagnitude(this.indexVersion, this.docVector);
    }

    @Override
    public int dotProduct(byte[] queryVector) {
        throw new UnsupportedOperationException("use [double dotProduct(float[] queryVector)] instead");
    }

    @Override
    public double dotProduct(float[] queryVector) {
        ByteBuffer byteBuffer = BinaryDenseVector.wrap(this.docVector);
        double dotProduct = 0.0;
        for (float v : queryVector) {
            dotProduct += (double)(byteBuffer.getFloat() * v);
        }
        return dotProduct;
    }

    @Override
    public double dotProduct(List<Number> queryVector) {
        ByteBuffer byteBuffer = BinaryDenseVector.wrap(this.docVector);
        double dotProduct = 0.0;
        for (int i = 0; i < queryVector.size(); ++i) {
            dotProduct += (double)(byteBuffer.getFloat() * queryVector.get(i).floatValue());
        }
        return dotProduct;
    }

    @Override
    public int l1Norm(byte[] queryVector) {
        throw new UnsupportedOperationException("use [double l1Norm(float[] queryVector)] instead");
    }

    @Override
    public double l1Norm(float[] queryVector) {
        ByteBuffer byteBuffer = BinaryDenseVector.wrap(this.docVector);
        double l1norm = 0.0;
        for (float v : queryVector) {
            l1norm += (double)Math.abs(v - byteBuffer.getFloat());
        }
        return l1norm;
    }

    @Override
    public double l1Norm(List<Number> queryVector) {
        ByteBuffer byteBuffer = BinaryDenseVector.wrap(this.docVector);
        double l1norm = 0.0;
        for (int i = 0; i < queryVector.size(); ++i) {
            l1norm += (double)Math.abs(queryVector.get(i).floatValue() - byteBuffer.getFloat());
        }
        return l1norm;
    }

    @Override
    public double l2Norm(byte[] queryVector) {
        throw new UnsupportedOperationException("use [double l2Norm(float[] queryVector)] instead");
    }

    @Override
    public double l2Norm(float[] queryVector) {
        ByteBuffer byteBuffer = BinaryDenseVector.wrap(this.docVector);
        double l2norm = 0.0;
        for (float queryValue : queryVector) {
            double diff = byteBuffer.getFloat() - queryValue;
            l2norm += diff * diff;
        }
        return Math.sqrt(l2norm);
    }

    @Override
    public double l2Norm(List<Number> queryVector) {
        ByteBuffer byteBuffer = BinaryDenseVector.wrap(this.docVector);
        double l2norm = 0.0;
        for (Number number : queryVector) {
            double diff = byteBuffer.getFloat() - number.floatValue();
            l2norm += diff * diff;
        }
        return Math.sqrt(l2norm);
    }

    @Override
    public double cosineSimilarity(byte[] queryVector, float qvMagnitude) {
        throw new UnsupportedOperationException("use [double cosineSimilarity(float[] queryVector, boolean normalizeQueryVector)] instead");
    }

    @Override
    public double cosineSimilarity(float[] queryVector, boolean normalizeQueryVector) {
        if (normalizeQueryVector) {
            return this.dotProduct(queryVector) / (double)(DenseVector.getMagnitude(queryVector) * this.getMagnitude());
        }
        return this.dotProduct(queryVector) / (double)this.getMagnitude();
    }

    @Override
    public double cosineSimilarity(List<Number> queryVector) {
        return this.dotProduct(queryVector) / (double)(DenseVector.getMagnitude(queryVector) * this.getMagnitude());
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    private static ByteBuffer wrap(BytesRef dv) {
        return ByteBuffer.wrap(dv.bytes, dv.offset, dv.length);
    }
}

