/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.DenseVectorScriptDocValues;
import org.elasticsearch.script.field.vectors.BinaryDenseVector;
import org.elasticsearch.script.field.vectors.DenseVector;
import org.elasticsearch.script.field.vectors.DenseVectorDocValuesField;

public class BinaryDenseVectorDocValuesField
extends DenseVectorDocValuesField {
    protected final BinaryDocValues input;
    protected final Version indexVersion;
    protected final int dims;
    protected BytesRef value;

    public BinaryDenseVectorDocValuesField(BinaryDocValues input, String name, DenseVectorFieldMapper.ElementType elementType, int dims, Version indexVersion) {
        super(name, elementType);
        this.input = input;
        this.indexVersion = indexVersion;
        this.dims = dims;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        this.value = this.input.advanceExact(docId) ? this.input.binaryValue() : null;
    }

    @Override
    public DenseVectorScriptDocValues toScriptDocValues() {
        return new DenseVectorScriptDocValues(this, this.dims);
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    public DenseVector get() {
        if (this.isEmpty()) {
            return DenseVector.EMPTY;
        }
        return new BinaryDenseVector(this.value, this.dims, this.indexVersion);
    }

    @Override
    public DenseVector get(DenseVector defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return new BinaryDenseVector(this.value, this.dims, this.indexVersion);
    }

    @Override
    public DenseVector getInternal() {
        return this.get(null);
    }
}

