/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class CardinalityAggregationBuilder
extends ValuesSourceAggregationBuilder.SingleMetricAggregationBuilder<CardinalityAggregationBuilder> {
    public static final String NAME = "cardinality";
    public static final ValuesSourceRegistry.RegistryKey<CardinalityAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<CardinalityAggregatorSupplier>("cardinality", CardinalityAggregatorSupplier.class);
    private static final ParseField REHASH = new ParseField("rehash", new String[0]).withAllDeprecated("no replacement - values will always be rehashed");
    public static final ParseField PRECISION_THRESHOLD_FIELD = new ParseField("precision_threshold", new String[0]);
    public static final ParseField EXECUTION_HINT_FIELD_NAME = new ParseField("execution_hint", new String[0]);
    public static final ObjectParser<CardinalityAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"cardinality", CardinalityAggregationBuilder::new);
    private Long precisionThreshold = null;
    private String executionHint = null;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        CardinalityAggregatorFactory.registerAggregators(builder);
    }

    public CardinalityAggregationBuilder(String name) {
        super(name);
    }

    public CardinalityAggregationBuilder(CardinalityAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.precisionThreshold = clone.precisionThreshold;
        this.executionHint = clone.executionHint;
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.KEYWORD;
    }

    public CardinalityAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.precisionThreshold = in.readLong();
        }
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_4_0)) {
            this.executionHint = in.readOptionalString();
        }
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new CardinalityAggregationBuilder(this, factoriesBuilder, metadata);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        boolean hasPrecisionThreshold = this.precisionThreshold != null;
        out.writeBoolean(hasPrecisionThreshold);
        if (hasPrecisionThreshold) {
            out.writeLong(this.precisionThreshold);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_4_0)) {
            out.writeOptionalString(this.executionHint);
        }
    }

    @Override
    public boolean supportsSampling() {
        return true;
    }

    @Override
    protected boolean serializeTargetValueType(TransportVersion version) {
        return true;
    }

    public CardinalityAggregationBuilder precisionThreshold(long precisionThreshold) {
        if (precisionThreshold < 0L) {
            throw new IllegalArgumentException("[precisionThreshold] must be greater than or equal to 0. Found [" + precisionThreshold + "] in [" + this.name + "]");
        }
        this.precisionThreshold = precisionThreshold;
        return this;
    }

    public Long precisionThreshold() {
        return this.precisionThreshold;
    }

    public String ExecutionHint() {
        return this.executionHint;
    }

    public void executionHint(String executionHint) {
        this.executionHint = executionHint;
    }

    @Override
    protected CardinalityAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        CardinalityAggregatorSupplier aggregatorSupplier = context.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config);
        return new CardinalityAggregatorFactory(this.name, config, this.precisionThreshold, this.executionHint, context, parent, subFactoriesBuilder, this.metadata, aggregatorSupplier);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.precisionThreshold != null) {
            builder.field(PRECISION_THRESHOLD_FIELD.getPreferredName(), this.precisionThreshold);
        }
        if (this.executionHint != null) {
            builder.field(EXECUTION_HINT_FIELD_NAME.getPreferredName(), this.executionHint);
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precisionThreshold, this.executionHint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CardinalityAggregationBuilder other = (CardinalityAggregationBuilder)obj;
        return Objects.equals(this.precisionThreshold, other.precisionThreshold) && Objects.equals(this.executionHint, other.executionHint);
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.ZERO;
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, false, false);
        PARSER.declareLong(CardinalityAggregationBuilder::precisionThreshold, PRECISION_THRESHOLD_FIELD);
        PARSER.declareLong((b, v) -> {}, REHASH);
        PARSER.declareString(CardinalityAggregationBuilder::executionHint, EXECUTION_HINT_FIELD_NAME);
    }
}

