/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.RescoreDocIds;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;

public class ShardFetchRequest
extends TransportRequest {
    private final ShardSearchContextId contextId;
    private final int[] docIds;
    private ScoreDoc lastEmittedDoc;

    public ShardFetchRequest(ShardSearchContextId contextId, List<Integer> docIds, ScoreDoc lastEmittedDoc) {
        this.contextId = contextId;
        this.docIds = docIds.stream().mapToInt(Integer::intValue).toArray();
        this.lastEmittedDoc = lastEmittedDoc;
    }

    public ShardFetchRequest(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
        int size = in.readVInt();
        this.docIds = new int[size];
        for (int i = 0; i < size; ++i) {
            this.docIds[i] = in.readVInt();
        }
        byte flag = in.readByte();
        if (flag == 1) {
            this.lastEmittedDoc = Lucene.readFieldDoc(in);
        } else if (flag == 2) {
            this.lastEmittedDoc = Lucene.readScoreDoc(in);
        } else if (flag != 0) {
            throw new IOException("Unknown flag: " + flag);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.contextId.writeTo(out);
        out.writeVIntArray(this.docIds);
        if (this.lastEmittedDoc == null) {
            out.writeByte((byte)0);
        } else if (this.lastEmittedDoc instanceof FieldDoc) {
            out.writeByte((byte)1);
            Lucene.writeFieldDoc(out, (FieldDoc)this.lastEmittedDoc);
        } else {
            out.writeByte((byte)2);
            Lucene.writeScoreDoc(out, this.lastEmittedDoc);
        }
    }

    public ShardSearchContextId contextId() {
        return this.contextId;
    }

    public int[] docIds() {
        return this.docIds;
    }

    public ScoreDoc lastEmittedDoc() {
        return this.lastEmittedDoc;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "id[" + this.contextId + "], size[" + this.docIds.length + "], lastEmittedDoc[" + this.lastEmittedDoc + "]";
    }

    @Nullable
    public ShardSearchRequest getShardSearchRequest() {
        return null;
    }

    @Nullable
    public RescoreDocIds getRescoreDocIds() {
        return null;
    }

    @Nullable
    public AggregatedDfs getAggregatedDfs() {
        return null;
    }
}

