/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public final class MatchedQueriesPhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext context) throws IOException {
        HashMap<String, Query> namedQueries = new HashMap<String, Query>();
        if (context.parsedQuery() != null) {
            namedQueries.putAll(context.parsedQuery().namedFilters());
        }
        if (context.parsedPostFilter() != null) {
            namedQueries.putAll(context.parsedPostFilter().namedFilters());
        }
        if (namedQueries.isEmpty()) {
            return null;
        }
        final HashMap<String, Weight> weights = new HashMap<String, Weight>();
        for (Map.Entry entry : namedQueries.entrySet()) {
            weights.put((String)entry.getKey(), context.searcher().createWeight(context.searcher().rewrite((Query)entry.getValue()), ScoreMode.COMPLETE_NO_SCORES, 1.0f));
        }
        return new FetchSubPhaseProcessor(){
            final Map<String, Bits> matchingIterators = new HashMap<String, Bits>();

            @Override
            public void setNextReader(LeafReaderContext readerContext) throws IOException {
                this.matchingIterators.clear();
                for (Map.Entry entry : weights.entrySet()) {
                    ScorerSupplier ss = ((Weight)entry.getValue()).scorerSupplier(readerContext);
                    if (ss == null) continue;
                    Bits matchingBits = Lucene.asSequentialAccessBits(readerContext.reader().maxDoc(), ss);
                    this.matchingIterators.put((String)entry.getKey(), matchingBits);
                }
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) {
                ArrayList<String> matches = new ArrayList<String>();
                int doc = hitContext.docId();
                for (Map.Entry<String, Bits> iterator : this.matchingIterators.entrySet()) {
                    if (!iterator.getValue().get(doc)) continue;
                    matches.add(iterator.getKey());
                }
                hitContext.hit().matchedQueries((String[])matches.toArray(String[]::new));
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                return StoredFieldsSpec.NO_REQUIREMENTS;
            }
        };
    }
}

