/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.subphase.highlight.SimpleFragmentsBuilder;
import org.elasticsearch.search.lookup.Source;

public class SourceSimpleFragmentsBuilder
extends SimpleFragmentsBuilder {
    private final FetchContext fetchContext;
    private final Source source;
    private final ValueFetcher valueFetcher;
    public static final Field[] EMPTY_FIELDS = new Field[0];

    public SourceSimpleFragmentsBuilder(MappedFieldType fieldType, FetchContext fetchContext, boolean fixBrokenAnalysis, Source source, String[] preTags, String[] postTags, BoundaryScanner boundaryScanner) {
        super(fieldType, fixBrokenAnalysis, preTags, postTags, boundaryScanner);
        this.fetchContext = fetchContext;
        this.source = source;
        this.valueFetcher = fieldType.valueFetcher(fetchContext.getSearchExecutionContext(), null);
    }

    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        List<Object> values = this.valueFetcher.fetchValues(this.source, docId, new ArrayList<Object>());
        if (values.isEmpty()) {
            return EMPTY_FIELDS;
        }
        if (values.size() > 1 && this.fetchContext.sourceLoader().reordersFieldValues()) {
            throw new IllegalArgumentException("The fast vector highlighter doesn't support loading multi-valued fields from _source in index [" + this.fetchContext.getIndexName() + "] because _source can reorder field values");
        }
        Field[] fields = new Field[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            fields[i] = new Field(this.fieldType.name(), (CharSequence)values.get(i).toString(), (IndexableFieldType)TextField.TYPE_NOT_STORED);
        }
        return fields;
    }
}

