/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class ShardSearchContextId
implements Writeable {
    private final String sessionId;
    private final long id;
    private final String searcherId;

    public ShardSearchContextId(String sessionId, long id) {
        this(sessionId, id, null);
    }

    public ShardSearchContextId(String sessionId, long id, String searcherId) {
        this.sessionId = Objects.requireNonNull(sessionId);
        this.id = id;
        this.searcherId = searcherId;
    }

    public ShardSearchContextId(StreamInput in) throws IOException {
        this.id = in.readLong();
        this.sessionId = in.getTransportVersion().onOrAfter(TransportVersion.V_7_7_0) ? in.readString() : "";
        this.searcherId = in.getTransportVersion().onOrAfter(TransportVersion.V_7_12_0) ? in.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.id);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_7_0)) {
            out.writeString(this.sessionId);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_12_0)) {
            out.writeOptionalString(this.searcherId);
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getId() {
        return this.id;
    }

    public String getSearcherId() {
        return this.searcherId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSearchContextId other = (ShardSearchContextId)o;
        return this.id == other.id && this.sessionId.equals(other.sessionId) && Objects.equals(this.searcherId, other.searcherId);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.id, this.searcherId);
    }

    public String toString() {
        return "[" + this.sessionId + "][" + this.id + "] searcherId [" + this.searcherId + "]";
    }
}

