/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.search.lookup.Source;

public interface SourceProvider {
    public Source getSource(LeafReaderContext var1, int var2) throws IOException;

    public static SourceProvider fromStoredFields() {
        final StoredFieldLoader storedFieldLoader = StoredFieldLoader.sequentialSource();
        return new SourceProvider(){
            LeafReaderContext ctx;
            int doc;
            LeafStoredFieldLoader leafStoredFieldLoader;
            Source source;

            @Override
            public Source getSource(LeafReaderContext ctx, int doc) throws IOException {
                if (this.ctx == ctx) {
                    if (this.doc == doc) {
                        return this.source;
                    }
                } else {
                    this.leafStoredFieldLoader = storedFieldLoader.getLoader(ctx, null);
                }
                this.ctx = ctx;
                this.doc = doc;
                this.leafStoredFieldLoader.advanceTo(doc);
                this.source = Source.fromBytes(this.leafStoredFieldLoader.source());
                return this.source;
            }
        };
    }
}

