/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.runtime.AbstractStringScriptFieldQuery;

public abstract class AbstractStringScriptFieldAutomatonQuery
extends AbstractStringScriptFieldQuery {
    private final BytesRefBuilder scratch = new BytesRefBuilder();
    private final ByteRunAutomaton automaton;

    public AbstractStringScriptFieldAutomatonQuery(Script script, StringFieldScript.LeafFactory leafFactory, String fieldName, ByteRunAutomaton automaton) {
        super(script, leafFactory, fieldName);
        this.automaton = automaton;
    }

    @Override
    protected final boolean matches(List<String> values) {
        for (String value : values) {
            this.scratch.copyChars((CharSequence)value);
            if (!this.automaton.run(this.scratch.bytes(), 0, this.scratch.length())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName())) {
            visitor.consumeTermsMatching((Query)this, this.fieldName(), () -> this.automaton);
        }
    }
}

