/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.suggest.Suggester;

public class SuggestionSearchContext {
    private final Map<String, SuggestionContext> suggestions = Maps.newLinkedHashMapWithExpectedSize(4);

    public void addSuggestion(String name, SuggestionContext suggestion) {
        this.suggestions.put(name, suggestion);
    }

    public Map<String, SuggestionContext> suggestions() {
        return this.suggestions;
    }

    public static abstract class SuggestionContext {
        private BytesRef text;
        private BytesRef prefix;
        private BytesRef regex;
        private String field;
        private Analyzer analyzer;
        private int size = 5;
        private int shardSize = -1;
        private SearchExecutionContext searchExecutionContext;
        private Suggester<?> suggester;

        protected SuggestionContext(Suggester<?> suggester, SearchExecutionContext searchExecutionContext) {
            this.suggester = suggester;
            this.searchExecutionContext = searchExecutionContext;
        }

        public BytesRef getText() {
            return this.text;
        }

        public void setText(BytesRef text) {
            this.text = text;
        }

        public BytesRef getPrefix() {
            return this.prefix;
        }

        public void setPrefix(BytesRef prefix) {
            this.prefix = prefix;
        }

        public BytesRef getRegex() {
            return this.regex;
        }

        public void setRegex(BytesRef regex) {
            this.regex = regex;
        }

        public Suggester<SuggestionContext> getSuggester() {
            return this.suggester;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public void setAnalyzer(Analyzer analyzer) {
            this.analyzer = analyzer;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Size must be positive but was: " + size);
            }
            this.size = size;
        }

        public Integer getShardSize() {
            return this.shardSize;
        }

        public void setShardSize(int shardSize) {
            if (shardSize <= 0) {
                throw new IllegalArgumentException("ShardSize must be positive but was: " + shardSize);
            }
            this.shardSize = shardSize;
        }

        public SearchExecutionContext getSearchExecutionContext() {
            return this.searchExecutionContext;
        }

        public String toString() {
            return "[text=" + this.text + ",field=" + this.field + ",prefix=" + this.prefix + ",regex=" + this.regex + ",size=" + this.size + ",shardSize=" + this.shardSize + ",suggester=" + this.suggester + ",analyzer=" + this.analyzer + ",searchExecutionContext=" + this.searchExecutionContext + "]";
        }
    }
}

