/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskId;

public class CancellableTask
extends Task {
    private volatile String reason;
    private volatile boolean isCancelled;
    private final ConcurrentLinkedQueue<CancellationListener> listeners = new ConcurrentLinkedQueue();

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        super(id, type, action, description, parentTaskId, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cancel(String reason) {
        assert (reason != null);
        CancellableTask cancellableTask = this;
        synchronized (cancellableTask) {
            if (this.isCancelled) {
                return;
            }
            this.isCancelled = true;
            this.reason = reason;
        }
        this.listeners.forEach(CancellationListener::onCancelled);
        this.onCancelled();
    }

    public boolean shouldCancelChildrenOnCancellation() {
        return true;
    }

    public final boolean isCancelled() {
        return this.isCancelled;
    }

    @Nullable
    public final String getReasonCancelled() {
        return this.reason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(CancellationListener listener) {
        CancellableTask cancellableTask = this;
        synchronized (cancellableTask) {
            if (!this.isCancelled) {
                this.listeners.add(listener);
            }
        }
        if (this.isCancelled) {
            listener.onCancelled();
        }
    }

    protected void onCancelled() {
    }

    public final synchronized void ensureNotCancelled() {
        if (this.isCancelled()) {
            throw this.getTaskCancelledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> boolean notifyIfCancelled(ActionListener<T> listener) {
        TaskCancelledException taskCancelledException;
        if (!this.isCancelled) {
            return false;
        }
        CancellableTask cancellableTask = this;
        synchronized (cancellableTask) {
            taskCancelledException = this.getTaskCancelledException();
        }
        listener.onFailure(taskCancelledException);
        return true;
    }

    private TaskCancelledException getTaskCancelledException() {
        assert (Thread.holdsLock(this));
        assert (this.isCancelled);
        assert (this.reason != null);
        return new TaskCancelledException("task cancelled [" + this.reason + "]");
    }

    public static interface CancellationListener {
        public void onCancelled();
    }
}

