/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.concurrent.Delayed;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.CancellableAdapter;
import org.elasticsearch.threadpool.ScheduledCancellableAdapter;

public interface Scheduler {
    public static ScheduledThreadPoolExecutor initScheduler(Settings settings, String schedulerName) {
        SafeScheduledThreadPoolExecutor scheduler = new SafeScheduledThreadPoolExecutor(1, EsExecutors.daemonThreadFactory(settings, schedulerName), new EsAbortPolicy());
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        scheduler.setRemoveOnCancelPolicy(true);
        return scheduler;
    }

    public static boolean terminate(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long timeout, TimeUnit timeUnit) {
        scheduledThreadPoolExecutor.shutdown();
        if (Scheduler.awaitTermination(scheduledThreadPoolExecutor, timeout, timeUnit)) {
            return true;
        }
        scheduledThreadPoolExecutor.shutdownNow();
        return Scheduler.awaitTermination(scheduledThreadPoolExecutor, timeout, timeUnit);
    }

    public static boolean awaitTermination(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long timeout, TimeUnit timeUnit) {
        try {
            if (scheduledThreadPoolExecutor.awaitTermination(timeout, timeUnit)) {
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public ScheduledCancellable schedule(Runnable var1, TimeValue var2, String var3);

    default public Cancellable scheduleWithFixedDelay(Runnable command, TimeValue interval, String executor) {
        return new ReschedulingRunnable(command, interval, executor, this, e -> {}, e -> {});
    }

    public static Cancellable wrapAsCancellable(Future<?> future) {
        return new CancellableAdapter(future);
    }

    public static ScheduledCancellable wrapAsScheduledCancellable(ScheduledFuture<?> scheduledFuture) {
        return new ScheduledCancellableAdapter(scheduledFuture);
    }

    public static class SafeScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
        public SafeScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, threadFactory, handler);
        }

        @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
        public SafeScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
        public SafeScheduledThreadPoolExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t != null) {
                return;
            }
            if (r instanceof RunnableFuture && ((RunnableFuture)r).isDone()) {
                ExceptionsHelper.reThrowIfNotNull(EsExecutors.rethrowErrors(r));
            }
        }
    }

    public static final class ReschedulingRunnable
    extends AbstractRunnable
    implements Cancellable {
        private final Runnable runnable;
        private final TimeValue interval;
        private final String executor;
        private final Scheduler scheduler;
        private final Consumer<Exception> rejectionConsumer;
        private final Consumer<Exception> failureConsumer;
        private volatile boolean run = true;

        ReschedulingRunnable(Runnable runnable, TimeValue interval, String executor, Scheduler scheduler, Consumer<Exception> rejectionConsumer, Consumer<Exception> failureConsumer) {
            this.runnable = runnable;
            this.interval = interval;
            this.executor = executor;
            this.scheduler = scheduler;
            this.rejectionConsumer = rejectionConsumer;
            this.failureConsumer = failureConsumer;
            scheduler.schedule(this, interval, executor);
        }

        @Override
        public boolean cancel() {
            boolean result = this.run;
            this.run = false;
            return result;
        }

        @Override
        public boolean isCancelled() {
            return !this.run;
        }

        @Override
        public void doRun() {
            if (this.run) {
                this.runnable.run();
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.failureConsumer.accept(e);
        }

        @Override
        public void onRejection(Exception e) {
            this.run = false;
            this.rejectionConsumer.accept(e);
        }

        @Override
        public void onAfter() {
            if (this.run) {
                try {
                    this.scheduler.schedule(this, this.interval, this.executor);
                }
                catch (EsRejectedExecutionException e) {
                    this.onRejection(e);
                }
            }
        }

        public String toString() {
            return "ReschedulingRunnable{runnable=" + this.runnable + ", interval=" + this.interval + "}";
        }
    }

    public static interface ScheduledCancellable
    extends Delayed,
    Cancellable {
    }

    public static interface Cancellable {
        public boolean cancel();

        public boolean isCancelled();
    }
}

