/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ClusterConnectionManager;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.RemoteConnectionInfo;
import org.elasticsearch.transport.RemoteConnectionManager;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

final class RemoteClusterConnection
implements Closeable {
    private final TransportService transportService;
    private final RemoteConnectionManager remoteConnectionManager;
    private final RemoteConnectionStrategy connectionStrategy;
    private final String clusterAlias;
    private final ThreadPool threadPool;
    private volatile boolean skipUnavailable;
    private final TimeValue initialConnectionTimeout;

    RemoteClusterConnection(Settings settings, String clusterAlias, TransportService transportService) {
        this.transportService = transportService;
        this.clusterAlias = clusterAlias;
        ConnectionProfile profile = RemoteConnectionStrategy.buildConnectionProfile(clusterAlias, settings);
        this.remoteConnectionManager = new RemoteConnectionManager(clusterAlias, RemoteClusterConnection.createConnectionManager(profile, transportService));
        this.connectionStrategy = RemoteConnectionStrategy.buildStrategy(clusterAlias, transportService, this.remoteConnectionManager, settings);
        this.remoteConnectionManager.addListener(transportService);
        this.skipUnavailable = RemoteClusterService.REMOTE_CLUSTER_SKIP_UNAVAILABLE.getConcreteSettingForNamespace(clusterAlias).get(settings);
        this.threadPool = transportService.threadPool;
        this.initialConnectionTimeout = RemoteClusterService.REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING.get(settings);
    }

    void setSkipUnavailable(boolean skipUnavailable) {
        this.skipUnavailable = skipUnavailable;
    }

    boolean isSkipUnavailable() {
        return this.skipUnavailable;
    }

    void ensureConnected(ActionListener<Void> listener) {
        if (this.remoteConnectionManager.size() == 0) {
            this.connectionStrategy.connect(listener);
        } else {
            listener.onResponse(null);
        }
    }

    void collectNodes(ActionListener<Function<String, DiscoveryNode>> listener) {
        Runnable runnable = () -> {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            ContextPreservingActionListener contextPreservingActionListener = new ContextPreservingActionListener(threadContext.newRestorableContext(false), listener);
            try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                threadContext.markAsSystemContext();
                ClusterStateRequest request = new ClusterStateRequest();
                request.clear();
                request.nodes(true);
                request.local(true);
                Transport.Connection connection = this.remoteConnectionManager.getAnyRemoteConnection();
                this.transportService.sendRequest(connection, "cluster:monitor/state", (TransportRequest)request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<ClusterStateResponse>(contextPreservingActionListener.map(response -> response.getState().nodes()::get), ClusterStateResponse::new));
            }
        };
        try {
            this.ensureConnected(ActionListener.wrap(x -> runnable.run(), listener::onFailure));
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    Transport.Connection getConnection(DiscoveryNode remoteClusterNode) {
        return this.remoteConnectionManager.getConnection(remoteClusterNode);
    }

    Transport.Connection getConnection() {
        return this.remoteConnectionManager.getAnyRemoteConnection();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.connectionStrategy, this.remoteConnectionManager});
    }

    public boolean isClosed() {
        return this.connectionStrategy.isClosed();
    }

    boolean assertNoRunningConnections() {
        return this.connectionStrategy.assertNoRunningConnections();
    }

    boolean isNodeConnected(DiscoveryNode node) {
        return this.remoteConnectionManager.nodeConnected(node);
    }

    public RemoteConnectionInfo getConnectionInfo() {
        return new RemoteConnectionInfo(this.clusterAlias, this.connectionStrategy.getModeInfo(), this.initialConnectionTimeout, this.skipUnavailable);
    }

    int getNumNodesConnected() {
        return this.remoteConnectionManager.size();
    }

    private static ConnectionManager createConnectionManager(ConnectionProfile connectionProfile, TransportService transportService) {
        return new ClusterConnectionManager(connectionProfile, transportService.transport, transportService.threadPool.getThreadContext());
    }

    ConnectionManager getConnectionManager() {
        return this.remoteConnectionManager;
    }

    boolean shouldRebuildConnection(Settings newSettings) {
        return this.connectionStrategy.shouldRebuildConnection(newSettings);
    }
}

