/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.memcached;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.transcoders.Transcoder;
import org.cryptacular.util.ByteUtil;
import org.cryptacular.util.CodecUtil;
import org.cryptacular.util.HashUtil;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.VersionMismatchException;
import org.opensaml.storage.annotation.AnnotationSupport;
import org.opensaml.storage.impl.memcached.MemcachedStorageCapabilities;
import org.opensaml.storage.impl.memcached.MemcachedStorageRecord;
import org.opensaml.storage.impl.memcached.StorageRecordTranscoder;
import org.opensaml.storage.impl.memcached.StringTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedStorageService
extends AbstractIdentifiableInitializableComponent
implements StorageService {
    protected static final String CTX_KEY_LIST_SUFFIX = ":contextKeyList";
    protected static final String CTX_KEY_BLACKLIST_SUFFIX = ":contextKeyBlackList";
    private static final String CTX_KEY_LIST_DELIMITER = "\n";
    private static final int MAX_KEY_LENGTH = 250;
    private final Logger logger = LoggerFactory.getLogger(MemcachedStorageService.class);
    private final Transcoder<MemcachedStorageRecord<?>> storageRecordTranscoder = new StorageRecordTranscoder();
    private final Transcoder<String> stringTranscoder = new StringTranscoder();
    @Nonnull
    private MemcachedStorageCapabilities storageCapabilities;
    @Nonnull
    private final MemcachedClient memcacheClient;
    @Positive
    private int operationTimeout;
    private boolean trackContextKeys;

    public MemcachedStorageService(@Nonnull MemcachedClient client, @Positive int timeout) {
        this(client, timeout, false);
    }

    public MemcachedStorageService(@Nonnull MemcachedClient client, @Positive int timeout, boolean enableContextKeyTracking) {
        Constraint.isNotNull((Object)client, (String)"Client cannot be null");
        Constraint.isGreaterThan((int)0, (int)timeout, (String)"Operation timeout must be positive");
        this.memcacheClient = client;
        this.operationTimeout = timeout;
        this.trackContextKeys = enableContextKeyTracking;
        this.storageCapabilities = new MemcachedStorageCapabilities();
    }

    @Nonnull
    public StorageCapabilities getCapabilities() {
        return this.storageCapabilities;
    }

    public void setCapabilities(@Nonnull MemcachedStorageCapabilities capabilities) {
        Constraint.isNotNull((Object)capabilities, (String)"Storage capabilities cannot be null");
        this.storageCapabilities = capabilities;
    }

    public boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)context), (String)"Context cannot be null or empty");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Key cannot be null or empty");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)value), (String)"Value cannot be null or empty");
        MemcachedStorageRecord record = new MemcachedStorageRecord(value, expiration);
        int expiry = record.getExpiry();
        Constraint.isGreaterThan((int)-1, (int)expiry, (String)"Expiration must be null or positive");
        String namespace = this.lookupNamespace(context);
        if (namespace == null) {
            namespace = this.createNamespace(context);
        }
        String cacheKey = this.memcachedKey(namespace, key);
        this.logger.debug("Creating new entry at {} for context={}, key={}, exp={}", new Object[]{cacheKey, context, key, expiry});
        boolean success = (Boolean)this.handleAsyncResult(this.memcacheClient.add(cacheKey, expiry, record, this.storageRecordTranscoder));
        if (success && this.trackContextKeys) {
            this.logger.debug("Tracking key {} for context {}", (Object)cacheKey, (Object)context);
            boolean result = this.updateContextKeyList(CTX_KEY_LIST_SUFFIX, namespace, cacheKey);
            if (!result) {
                this.logger.debug("Failed appending {} to list of keys for context {}", (Object)cacheKey, (Object)context);
                this.handleAsyncResult(this.memcacheClient.delete(cacheKey));
            }
            return result;
        }
        return success;
    }

    public <T> boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull T value, @Nonnull StorageSerializer<T> serializer, @Nullable @Positive Long expiration) throws IOException {
        Constraint.isNotNull(serializer, (String)"Serializer cannot be null");
        return this.create(context, key, serializer.serialize(value), expiration);
    }

    public boolean create(@Nonnull Object value) throws IOException {
        Constraint.isNotNull((Object)value, (String)"Value cannot be null");
        return this.create(AnnotationSupport.getContext((Object)value), AnnotationSupport.getKey((Object)value), AnnotationSupport.getValue((Object)value), AnnotationSupport.getExpiration((Object)value));
    }

    public <T> StorageRecord<T> read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        CASValue record;
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)context), (String)"Context cannot be null or empty");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Key cannot be null or empty");
        String namespace = this.lookupNamespace(context);
        if (namespace == null) {
            this.logger.debug("Namespace for context {} does not exist", (Object)context);
            return null;
        }
        String cacheKey = this.memcachedKey(namespace, key);
        this.logger.debug("Reading entry at {} for context={}, key={}", new Object[]{cacheKey, context, key});
        try {
            record = (CASValue)this.handleAsyncResult(this.memcacheClient.asyncGets(cacheKey, this.storageRecordTranscoder));
        }
        catch (RuntimeException e) {
            throw new IOException("Memcached operation failed", e);
        }
        if (record == null) {
            return null;
        }
        ((MemcachedStorageRecord)((Object)record.getValue())).setVersion(record.getCas());
        return (StorageRecord)record.getValue();
    }

    public Object read(@Nonnull Object value) throws IOException {
        Constraint.isNotNull((Object)value, (String)"Value cannot be null");
        return this.read(AnnotationSupport.getContext((Object)value), AnnotationSupport.getKey((Object)value));
    }

    public <T> Pair<Long, StorageRecord<T>> read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Positive long version) throws IOException {
        Constraint.isGreaterThan((long)0L, (long)version, (String)"Version must be positive");
        StorageRecord<T> record = this.read(context, key);
        if (record == null) {
            return new Pair();
        }
        Pair result = new Pair((Object)record.getVersion(), null);
        if (version != record.getVersion()) {
            result.setSecond(record);
        }
        return result;
    }

    public boolean update(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)context), (String)"Context cannot be null or empty");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Key cannot be null or empty");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)value), (String)"Value cannot be null or empty");
        MemcachedStorageRecord record = new MemcachedStorageRecord(value, expiration);
        int expiry = record.getExpiry();
        Constraint.isGreaterThan((int)-1, (int)expiry, (String)"Expiration must be null or positive");
        String namespace = this.lookupNamespace(context);
        if (namespace == null) {
            this.logger.debug("Namespace for context {} does not exist", (Object)context);
            return false;
        }
        String cacheKey = this.memcachedKey(namespace, key);
        this.logger.debug("Updating entry at {} for context={}, key={}, exp={}", new Object[]{cacheKey, context, key, expiry});
        return (Boolean)this.handleAsyncResult(this.memcacheClient.replace(cacheKey, expiry, record, this.storageRecordTranscoder));
    }

    public <T> boolean update(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull T value, @Nonnull StorageSerializer<T> serializer, @Nullable @Positive Long expiration) throws IOException {
        Constraint.isNotNull(serializer, (String)"Serializer cannot be null");
        return this.update(context, key, serializer.serialize(value), expiration);
    }

    public boolean update(@Nonnull Object value) throws IOException {
        Constraint.isNotNull((Object)value, (String)"Value cannot be null");
        return this.update(AnnotationSupport.getContext((Object)value), AnnotationSupport.getKey((Object)value), AnnotationSupport.getValue((Object)value), AnnotationSupport.getExpiration((Object)value));
    }

    public Long updateWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        Constraint.isGreaterThan((long)0L, (long)version, (String)"Version must be positive");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)context), (String)"Context cannot be null or empty");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Key cannot be null or empty");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)value), (String)"Value cannot be null or empty");
        MemcachedStorageRecord record = new MemcachedStorageRecord(value, expiration);
        int expiry = record.getExpiry();
        Constraint.isGreaterThan((int)-1, (int)expiry, (String)"Expiration must be null or positive");
        String namespace = this.lookupNamespace(context);
        if (namespace == null) {
            this.logger.debug("Namespace for context {} does not exist", (Object)context);
            return null;
        }
        String cacheKey = this.memcachedKey(namespace, key);
        this.logger.debug("Updating entry at {} for context={}, key={}, version={}, exp={}", new Object[]{cacheKey, context, key, version, expiry});
        CASResponse response = (CASResponse)this.handleAsyncResult(this.memcacheClient.asyncCAS(cacheKey, version, expiry, record, this.storageRecordTranscoder));
        Long newVersion = null;
        if (CASResponse.OK == response) {
            CASValue newRecord = (CASValue)this.handleAsyncResult(this.memcacheClient.asyncGets(cacheKey, this.storageRecordTranscoder));
            if (newRecord != null) {
                newVersion = newRecord.getCas();
            }
        } else if (CASResponse.EXISTS == response) {
            throw new VersionMismatchException();
        }
        return newVersion;
    }

    @Nullable
    public <T> Long updateWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull T value, @Nonnull StorageSerializer<T> serializer, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        Constraint.isNotNull(serializer, (String)"Serializer cannot be null");
        return this.updateWithVersion(version, context, key, serializer.serialize(value), expiration);
    }

    @Nullable
    public Long updateWithVersion(@Positive long version, @Nonnull Object value) throws IOException, VersionMismatchException {
        Constraint.isNotNull((Object)value, (String)"Value cannot be null");
        return this.updateWithVersion(version, AnnotationSupport.getContext((Object)value), AnnotationSupport.getKey((Object)value), AnnotationSupport.getValue((Object)value), AnnotationSupport.getExpiration((Object)value));
    }

    public boolean updateExpiration(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable @Positive Long expiration) throws IOException {
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)context), (String)"Context cannot be null or empty");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Key cannot be null or empty");
        int expiry = MemcachedStorageRecord.expiry(expiration);
        Constraint.isGreaterThan((int)-1, (int)expiry, (String)"Expiration must be null or positive");
        String namespace = this.lookupNamespace(context);
        if (namespace == null) {
            this.logger.debug("Namespace for context {} does not exist", (Object)context);
            return false;
        }
        String cacheKey = this.memcachedKey(namespace, key);
        this.logger.debug("Updating expiration for entry at {} for context={}, key={}", new Object[]{cacheKey, context, key});
        return (Boolean)this.handleAsyncResult(this.memcacheClient.touch(cacheKey, expiry));
    }

    public boolean updateExpiration(@Nonnull Object value) throws IOException {
        Constraint.isNotNull((Object)value, (String)"Value cannot be null");
        return this.updateExpiration(AnnotationSupport.getContext((Object)value), AnnotationSupport.getKey((Object)value), AnnotationSupport.getExpiration((Object)value));
    }

    public boolean delete(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)context), (String)"Context cannot be null or empty");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Key cannot be null or empty");
        String namespace = this.lookupNamespace(context);
        if (namespace == null) {
            this.logger.debug("Namespace for context {} does not exist", (Object)context);
            return false;
        }
        String cacheKey = this.memcachedKey(namespace, key);
        this.logger.debug("Deleting entry at {} for context={}, key={}", new Object[]{cacheKey, context, key});
        boolean success = (Boolean)this.handleAsyncResult(this.memcacheClient.delete(cacheKey));
        if (success && this.trackContextKeys) {
            this.logger.debug("Blacklisting key {} for context {}", (Object)cacheKey, (Object)context);
            if (!this.updateContextKeyList(CTX_KEY_BLACKLIST_SUFFIX, namespace, cacheKey)) {
                this.logger.debug("Failed appending {} to list of blacklisted keys for context {}", (Object)cacheKey, (Object)context);
            }
        }
        return success;
    }

    public boolean delete(@Nonnull Object value) throws IOException {
        Constraint.isNotNull((Object)value, (String)"Value cannot be null");
        return this.delete(AnnotationSupport.getContext((Object)value), AnnotationSupport.getKey((Object)value));
    }

    public boolean deleteWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        Constraint.isGreaterThan((long)0L, (long)version, (String)"Version must be positive");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)context), (String)"Context cannot be null or empty");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Key cannot be null or empty");
        String namespace = this.lookupNamespace(context);
        if (namespace == null) {
            this.logger.debug("Namespace for context {} does not exist", (Object)context);
            return false;
        }
        String cacheKey = this.memcachedKey(namespace, key);
        this.logger.debug("Deleting entry at {} for context={}, key={}, version={}", new Object[]{cacheKey, context, key, version});
        boolean success = (Boolean)this.handleAsyncResult(this.memcacheClient.delete(cacheKey, version));
        if (success && this.trackContextKeys) {
            this.logger.debug("Blacklisting key {} for context {}", (Object)cacheKey, (Object)context);
            if (!this.updateContextKeyList(CTX_KEY_BLACKLIST_SUFFIX, namespace, cacheKey)) {
                this.logger.debug("Failed appending {} to list of blacklisted keys for context {}", (Object)cacheKey, (Object)context);
            }
        }
        return success;
    }

    public boolean deleteWithVersion(@Positive long version, @Nonnull Object value) throws IOException, VersionMismatchException {
        Constraint.isNotNull((Object)value, (String)"Value cannot be null");
        return this.deleteWithVersion(version, AnnotationSupport.getContext((Object)value), AnnotationSupport.getKey((Object)value));
    }

    public void reap(@Nonnull @NotEmpty String context) throws IOException {
    }

    public void updateContextExpiration(@Nonnull @NotEmpty String context, @Nullable Long expiration) throws IOException {
        if (!this.trackContextKeys) {
            throw new UnsupportedOperationException("updateContextExpiration not supported when trackContextKeys == false");
        }
        int expiry = MemcachedStorageRecord.expiry(expiration);
        Constraint.isGreaterThan((int)-1, (int)expiry, (String)"Expiration must be null or positive");
        String namespace = this.lookupNamespace(context);
        if (namespace == null) {
            this.logger.debug("Cannot update context expiration since context namespace does not exist");
            return;
        }
        CASValue keys = (CASValue)this.handleAsyncResult(this.memcacheClient.asyncGets(namespace + CTX_KEY_LIST_SUFFIX, this.stringTranscoder));
        if (keys == null) {
            this.logger.debug("No context keys found to update expiration");
            return;
        }
        HashSet<String> keySet = new HashSet<String>(Arrays.asList(((String)keys.getValue()).split(CTX_KEY_LIST_DELIMITER)));
        CASValue blacklistKeys = (CASValue)this.handleAsyncResult(this.memcacheClient.asyncGets(namespace + CTX_KEY_BLACKLIST_SUFFIX, this.stringTranscoder));
        if (blacklistKeys != null) {
            keySet.removeAll(Arrays.asList(((String)blacklistKeys.getValue()).split(CTX_KEY_LIST_DELIMITER)));
        }
        ArrayList<OperationFuture> results = new ArrayList<OperationFuture>(keySet.size());
        for (String key : keySet) {
            this.logger.debug("Updating expiration of key {} to {}", (Object)key, (Object)expiry);
            results.add(this.memcacheClient.touch(key, expiry));
        }
        for (OperationFuture result : results) {
            this.handleAsyncResult(result);
        }
    }

    public void deleteContext(@Nonnull @NotEmpty String context) throws IOException {
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)context), (String)"Context cannot be null or empty");
        String namespace = this.lookupNamespace(context);
        if (namespace == null) {
            this.logger.debug("Namespace for context {} does not exist. Context values effectively deleted.", (Object)context);
            return;
        }
        OperationFuture ctxResult = this.memcacheClient.delete(context);
        OperationFuture nsResult = this.memcacheClient.delete(namespace);
        if (this.trackContextKeys) {
            OperationFuture keyListResult = this.memcacheClient.delete(namespace + CTX_KEY_LIST_SUFFIX);
            OperationFuture blackListResult = this.memcacheClient.delete(namespace + CTX_KEY_BLACKLIST_SUFFIX);
            this.handleAsyncResult(keyListResult);
            this.handleAsyncResult(blackListResult);
        }
        this.handleAsyncResult(ctxResult);
        this.handleAsyncResult(nsResult);
    }

    protected void doDestroy() {
        this.memcacheClient.shutdown();
    }

    protected String lookupNamespace(String context) throws IOException {
        try {
            CASValue result = (CASValue)this.handleAsyncResult(this.memcacheClient.asyncGets(this.memcachedKey(context), this.stringTranscoder));
            return result == null ? null : (String)result.getValue();
        }
        catch (RuntimeException e) {
            throw new IOException("Memcached operation failed", e);
        }
    }

    protected String createNamespace(String context) throws IOException {
        String namespace = null;
        boolean success = false;
        while (!success) {
            namespace = CodecUtil.hex((byte[])ByteUtil.toBytes((long)System.currentTimeMillis()));
            success = (Boolean)this.handleAsyncResult(this.memcacheClient.add(namespace, 0, (Object)context, this.stringTranscoder));
        }
        if (!((Boolean)this.handleAsyncResult(this.memcacheClient.add(this.memcachedKey(context), 0, (Object)namespace, this.stringTranscoder))).booleanValue()) {
            throw new IllegalStateException(context + " already exists");
        }
        return namespace;
    }

    private String memcachedKey(String ... parts) {
        String key;
        if (parts.length > 0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (String part : parts) {
                if (i++ > 0) {
                    sb.append(':');
                }
                sb.append(part);
            }
            key = sb.toString();
        } else {
            key = parts[0];
        }
        if (key.length() > 250) {
            return CodecUtil.hex((byte[])HashUtil.sha512((Object[])new Object[]{key}));
        }
        return key;
    }

    private <T> T handleAsyncResult(OperationFuture<T> result) throws IOException {
        try {
            return (T)result.get((long)this.operationTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException("Memcached operation interrupted");
        }
        catch (TimeoutException e) {
            throw new IOException("Memcached operation did not complete in time (" + this.operationTimeout + "s)");
        }
        catch (ExecutionException e) {
            throw new IOException("Memcached operation error", e);
        }
    }

    private boolean updateContextKeyList(String suffix, String namespace, String key) throws IOException {
        String newItem;
        String listKey = namespace + suffix;
        boolean success = (Boolean)this.handleAsyncResult(this.memcacheClient.append(listKey, (Object)(newItem = key + CTX_KEY_LIST_DELIMITER), this.stringTranscoder));
        if (!success) {
            return (Boolean)this.handleAsyncResult(this.memcacheClient.add(listKey, 0, (Object)newItem, this.stringTranscoder));
        }
        return success;
    }
}

