/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualParameter;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.arm.tree.ArmTreeUtils;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.File;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.ParameterDeclaration;
import org.sonar.iac.arm.tree.api.ParameterType;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;

@Rule(key="S6648")
public class SecureParameterDefaultValueCheck
implements IacCheck {
    private static final String MESSAGE = "Remove the default value from this secure %s.";
    private static final Pattern jsonParameters = Pattern.compile("^\\[\\s*+parameters\\('(?<name>.*)'\\)\\s*+\\]$");
    private static final Map<ParameterType, String> SENSITIVE_TYPE_WITH_DISPLAY_TYPE = Map.of(ParameterType.SECURE_STRING, "string", ParameterType.SECURE_OBJECT, "object");

    @Override
    public void initialize(InitContext init) {
        init.register(ParameterDeclaration.class, SecureParameterDefaultValueCheck::checkParameter);
    }

    private static void checkParameter(CheckContext ctx, ParameterDeclaration parameterDeclaration) {
        ParameterType type = parameterDeclaration.type();
        if (type != null && SENSITIVE_TYPE_WITH_DISPLAY_TYPE.containsKey((Object)type)) {
            ContextualParameter param = ContextualParameter.fromPresent(ctx, parameterDeclaration, null);
            param.reportIf(SecureParameterDefaultValueCheck.isSensitiveDefaultValue(), String.format(MESSAGE, SENSITIVE_TYPE_WITH_DISPLAY_TYPE.get((Object)type)), new SecondaryLocation[0]);
        }
    }

    private static Predicate<Expression> isSensitiveDefaultValue() {
        return CheckUtils.isBlankString().or(CheckUtils.isEmptyObject()).or(CheckUtils.isNull()).or(CheckUtils.isFunctionCall("newGuid")).or(SecureParameterDefaultValueCheck.isSecureParameterReference()).negate();
    }

    private static Predicate<Expression> isSecureParameterReference() {
        return expr -> {
            StringLiteral stringLiteral;
            Matcher matcher;
            if (expr.is(ArmTree.Kind.IDENTIFIER)) {
                Identifier identifier = (Identifier)expr;
                return SecureParameterDefaultValueCheck.isSecureParameter(identifier, identifier.value());
            }
            if (expr.is(ArmTree.Kind.STRING_LITERAL) && (matcher = jsonParameters.matcher((stringLiteral = (StringLiteral)expr).value())).find()) {
                return SecureParameterDefaultValueCheck.isSecureParameter(stringLiteral, matcher.group("name"));
            }
            return false;
        };
    }

    private static boolean isSecureParameter(ArmTree tree, String parameterName) {
        ParameterDeclaration param = SecureParameterDefaultValueCheck.getParametersByNames(tree).get(parameterName);
        return param != null && SENSITIVE_TYPE_WITH_DISPLAY_TYPE.containsKey((Object)param.type());
    }

    private static Map<String, ParameterDeclaration> getParametersByNames(ArmTree tree) {
        File file = (File)ArmTreeUtils.getRootNode(tree);
        return file.statements().stream().filter(ParameterDeclaration.class::isInstance).map(ParameterDeclaration.class::cast).collect(Collectors.toMap(param -> param.declaratedName().value(), param -> param));
    }
}

