/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualMap;
import org.sonar.iac.arm.checkdsl.ContextualObject;
import org.sonar.iac.arm.checkdsl.ContextualProperty;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6388")
public class UnencryptedCloudServicesCheck
extends AbstractArmResourceCheck {
    public static final String UNENCRYPTED_MESSAGE = "Make sure that using unencrypted cloud storage is safe here.";
    public static final String FORMAT_OMITTING = "Omitting \"%s\" enables clear-text storage. Make sure it is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Compute/virtualMachines", (ContextualResource resource) -> Stream.of("storageProfile/dataDisks/*/managedDisk", "storageProfile/osDisk/managedDisk", "storageProfile/osDisk/managedDisk/securityProfile").map(resource::objectsByPath).flatMap(Collection::stream).forEach(UnencryptedCloudServicesCheck::checkForDiskEncryptionSet));
        this.register("Microsoft.Compute/virtualMachines", (ContextualResource resource) -> ((ContextualProperty)resource.object("storageProfile").object("osDisk").property("encryptionSettings").reportIf(CheckUtils.isFalse(), UNENCRYPTED_MESSAGE, new SecondaryLocation[0])).reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]));
        this.register("Microsoft.Compute/virtualMachineScaleSets", (ContextualResource resource) -> Stream.of("virtualMachineProfile/storageProfile/dataDisks/*/managedDisk", "virtualMachineProfile/storageProfile/dataDisks/*/managedDisk/securityProfile", "virtualMachineProfile/storageProfile/osDisk/managedDisk/", "virtualMachineProfile/storageProfile/osDisk/managedDisk/securityProfile").map(resource::objectsByPath).flatMap(Collection::stream).forEach(UnencryptedCloudServicesCheck::checkForDiskEncryptionSet));
        this.register("Microsoft.DocumentDB/cassandraClusters/dataCenters", (ContextualResource resource) -> {
            resource.property("backupStorageCustomerKeyUri").reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]);
            resource.property("managedDiskCustomerKeyUri").reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]);
        });
        this.register("Microsoft.ContainerService/managedClusters", (ContextualResource resource) -> resource.property("diskEncryptionSetID").reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]));
        this.register("Microsoft.RedHatOpenShift/openShiftClusters", (ContextualResource resource) -> {
            ContextualObject masterProfile = resource.object("masterProfile");
            masterProfile.property("diskEncryptionSetId").reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]);
            UnencryptedCloudServicesCheck.checkIfIsDisabledOrAbsent(masterProfile.property("encryptionAtHost"));
            resource.list("workerProfiles").objects().forEach(workerProfile -> {
                workerProfile.property("diskEncryptionSetId").reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]);
                UnencryptedCloudServicesCheck.checkIfIsDisabledOrAbsent(workerProfile.property("encryptionAtHost"));
            });
        });
        this.register("Microsoft.DataLakeStore/accounts", (ContextualResource resource) -> ((ContextualProperty)resource.property("encryptionState").reportIf(UnencryptedCloudServicesCheck.isDisabled().or(UnencryptedCloudServicesCheck.isNull()), UNENCRYPTED_MESSAGE, new SecondaryLocation[0])).reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]));
        this.register(List.of("Microsoft.DBforMySQL/servers", "Microsoft.DBforPostgreSQL/servers"), (ContextualResource resource) -> UnencryptedCloudServicesCheck.checkIfIsDisabledOrAbsent(resource.property("infrastructureEncryption")));
        this.register("Microsoft.RecoveryServices/vaults", (ContextualResource resource) -> UnencryptedCloudServicesCheck.checkIfIsDisabledOrAbsent(resource.object("encryption").property("infrastructureEncryption")));
        this.register("Microsoft.RecoveryServices/vaults/backupEncryptionConfigs", (ContextualResource resource) -> UnencryptedCloudServicesCheck.checkIfIsDisabledOrAbsent(resource.property("infrastructureEncryptionState")));
        this.register("Microsoft.Storage/storageAccounts", (ContextualResource resource) -> ((ContextualProperty)((ContextualMap)resource.object("encryption").reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0])).property("requireInfrastructureEncryption").reportIf(CheckUtils.isFalse(), UNENCRYPTED_MESSAGE, new SecondaryLocation[0])).reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]));
        this.register("Microsoft.Storage/storageAccounts/encryptionScopes", (ContextualResource resource) -> ((ContextualProperty)resource.property("requireInfrastructureEncryption").reportIf(CheckUtils.isFalse(), UNENCRYPTED_MESSAGE, new SecondaryLocation[0])).reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]));
        this.register(List.of("Microsoft.Compute/disks", "Microsoft.Compute/snapshots"), UnencryptedCloudServicesCheck.checkComputeComponent());
        this.register("Microsoft.Compute/virtualMachineScaleSets", UnencryptedCloudServicesCheck.checkEncryptionFromPath("virtualMachineProfile/securityProfile", "encryptionAtHost"));
        this.register("Microsoft.Compute/virtualMachines", UnencryptedCloudServicesCheck.checkEncryptionFromPath("securityProfile", "encryptionAtHost"));
        this.register("Microsoft.SqlVirtualMachine/sqlVirtualMachines", UnencryptedCloudServicesCheck.checkEncryptionFromPath("autoBackupSettings", "enableEncryption"));
        this.register("Microsoft.ContainerService/managedClusters", UnencryptedCloudServicesCheck.checkEncryptionFromPath("agentPoolProfiles/*", "enableEncryptionAtHost"));
        this.register("Microsoft.AzureArcData/sqlServerInstances/databases", UnencryptedCloudServicesCheck.checkEncryptionFromPath("databaseOptions", "isEncrypted"));
        this.register("Microsoft.HDInsight/clusters", UnencryptedCloudServicesCheck.checkEncryptionFromPath("computeProfile/roles/*", "encryptDataDisks"));
        this.register("Microsoft.HDInsight/clusters", UnencryptedCloudServicesCheck.checkEncryptionFromPath("diskEncryptionProperties", "encryptionAtHost"));
        this.register("Microsoft.HDInsight/clusters/applications", UnencryptedCloudServicesCheck.checkEncryptionFromPath("computeProfile/roles/*", "encryptDataDisks"));
        this.register("Microsoft.Kusto/clusters", (ContextualResource resource) -> UnencryptedCloudServicesCheck.checkEncryptionObject(resource, "enableDiskEncryption"));
    }

    private static Consumer<ContextualResource> checkComputeComponent() {
        return resource -> {
            ContextualProperty secureVMDiskEncryptionSetId;
            ContextualProperty encryptionSettingsCollectionEnabled;
            ContextualProperty diskEncryptionSetId = resource.object("encryption").property("diskEncryptionSetId");
            if (UnencryptedCloudServicesCheck.isUnencryptedComputeComponent(diskEncryptionSetId, encryptionSettingsCollectionEnabled = resource.object("encryptionSettingsCollection").property("enabled"), secureVMDiskEncryptionSetId = resource.object("securityProfile").property("secureVMDiskEncryptionSetId"))) {
                if (encryptionSettingsCollectionEnabled.isPresent() && encryptionSettingsCollectionEnabled.is(CheckUtils.isFalse())) {
                    encryptionSettingsCollectionEnabled.report(UNENCRYPTED_MESSAGE, new SecondaryLocation[0]);
                } else {
                    resource.report(String.format(FORMAT_OMITTING, "encryption.diskEncryptionSetId\", \"encryptionSettingsCollection\" or \"securityProfile.secureVMDiskEncryptionSetId"), new SecondaryLocation[0]);
                }
            }
        };
    }

    private static boolean isUnencryptedComputeComponent(ContextualProperty diskEncryptionSetId, ContextualProperty encryptionSettingsCollectionEnabled, ContextualProperty secureVMDiskEncryptionSetId) {
        return diskEncryptionSetId.isAbsent() && (encryptionSettingsCollectionEnabled.isAbsent() || encryptionSettingsCollectionEnabled.is(CheckUtils.isFalse())) && secureVMDiskEncryptionSetId.isAbsent();
    }

    private static void checkIfIsDisabledOrAbsent(ContextualProperty property) {
        ((ContextualProperty)property.reportIf(UnencryptedCloudServicesCheck.isDisabled(), UNENCRYPTED_MESSAGE, new SecondaryLocation[0])).reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]);
    }

    private static Predicate<Expression> isNull() {
        return e -> e.is(ArmTree.Kind.NULL_LITERAL);
    }

    private static Predicate<Expression> isDisabled() {
        return CheckUtils.isEqual("Disabled");
    }

    private static Consumer<ContextualResource> checkEncryptionFromPath(String objectsPath, String encryptionProperty) {
        return resource -> resource.objectsByPath(objectsPath).forEach(obj -> UnencryptedCloudServicesCheck.checkEncryptionObject(obj, encryptionProperty));
    }

    private static void checkEncryptionObject(ContextualMap<?, ?> obj, String encryptionProperty) {
        ((ContextualProperty)obj.property(encryptionProperty).reportIf(CheckUtils.isFalse(), UNENCRYPTED_MESSAGE, new SecondaryLocation[0])).reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]);
    }

    private static void checkForDiskEncryptionSet(ContextualObject profile) {
        ((ContextualProperty)((ContextualMap)profile.object("diskEncryptionSet").reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0])).property("id").reportIf(UnencryptedCloudServicesCheck.isEmpty(), String.format(FORMAT_OMITTING, "id"), new SecondaryLocation[0])).reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]);
    }

    private static Predicate<Expression> isEmpty() {
        return e -> TextUtils.matchesValue(e, ""::equals).isTrue();
    }
}

