/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.ArrayExpression;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.File;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.ParameterDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;

public class ArmTreeUtils {
    public static final String ARRAY_TOKEN = "*";
    private static final Pattern jsonParameters = Pattern.compile("^\\[\\s*+parameters\\('(?<name>.*)'\\)\\s*+\\]$");

    private ArmTreeUtils() {
    }

    public static List<String> computePath(String path) {
        return Arrays.asList(path.split("/"));
    }

    public static List<Tree> resolveProperties(String path, Tree tree) {
        LinkedList<String> pathElements = new LinkedList<String>(Arrays.asList(path.split("/")));
        return ArmTreeUtils.resolveProperties(pathElements, tree);
    }

    public static List<Tree> resolveProperties(Queue<String> path, Tree tree) {
        while (!path.isEmpty() && tree != null) {
            String nextPath = path.poll();
            if (nextPath.equals(ARRAY_TOKEN)) {
                if (tree instanceof ArrayExpression) {
                    ArrayExpression array = (ArrayExpression)tree;
                    ArrayList<Tree> trees = new ArrayList<Tree>();
                    array.elements().forEach(element -> trees.addAll(ArmTreeUtils.resolveProperties(new LinkedList<String>(path), (Tree)element)));
                    return trees;
                }
                return Collections.emptyList();
            }
            tree = PropertyUtils.value(tree, nextPath).orElse(null);
        }
        return tree != null ? List.of(tree) : Collections.emptyList();
    }

    public static ArmTree getRootNode(ArmTree tree) {
        ArmTree parent;
        while ((parent = tree.parent()) != null) {
            tree = parent;
        }
        return tree;
    }

    public static Map<String, ParameterDeclaration> getParametersByNames(ArmTree tree) {
        File file = (File)ArmTreeUtils.getRootNode(tree);
        return file.statements().stream().filter(ParameterDeclaration.class::isInstance).map(ParameterDeclaration.class::cast).collect(Collectors.toMap(param -> param.declaratedName().value(), param -> param));
    }

    public static Predicate<Expression> containsParameterReference(Collection<String> parameterNames) {
        return expr -> {
            Matcher matcher;
            if (expr.is(ArmTree.Kind.IDENTIFIER)) {
                return parameterNames.contains(((Identifier)expr).value());
            }
            if (expr.is(ArmTree.Kind.STRING_LITERAL) && (matcher = jsonParameters.matcher(((StringLiteral)expr).value())).find()) {
                return parameterNames.contains(matcher.group("name"));
            }
            return false;
        };
    }
}

