/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.impl.bicep;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.ObjectExpression;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.arm.tree.api.bicep.ObjectProperty;
import org.sonar.iac.arm.tree.api.bicep.SyntaxToken;
import org.sonar.iac.arm.tree.impl.AbstractArmTreeImpl;
import org.sonar.iac.common.api.tree.Tree;

public class ObjectExpressionImpl
extends AbstractArmTreeImpl
implements ObjectExpression {
    private final SyntaxToken leftCurlyBrace;
    private final List<ObjectProperty> objectProperties;
    private final SyntaxToken rightCurlyBrace;

    public ObjectExpressionImpl(SyntaxToken leftCurlyBrace, List<ObjectProperty> objectProperties, SyntaxToken rightCurlyBrace) {
        this.leftCurlyBrace = leftCurlyBrace;
        this.objectProperties = objectProperties;
        this.rightCurlyBrace = rightCurlyBrace;
    }

    public List<Property> properties() {
        return this.objectProperties.stream().filter(Property.class::isInstance).map(Property.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<ResourceDeclaration> nestedResources() {
        return this.objectProperties.stream().filter(ResourceDeclaration.class::isInstance).map(ResourceDeclaration.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> list = new ArrayList<Tree>();
        list.add(this.leftCurlyBrace);
        list.addAll(this.objectProperties);
        list.add(this.rightCurlyBrace);
        return list;
    }

    @Override
    public ArmTree.Kind getKind() {
        return ArmTree.Kind.OBJECT_EXPRESSION;
    }
}

