/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.plugin;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;

public class CloudformationSettings {
    private static final String CLOUDFORMATION_CATEGORY = "CloudFormation";
    private static final String GENERAL_SUBCATEGORY = "General";
    private static final String EXTERNAL_ANALYZERS_CATEGORY = "External Analyzers";
    static final String ACTIVATION_KEY = "sonar.cloudformation.activate";
    static final String ACTIVATION_DEFAULT_VALUE = "true";
    static final String FILE_IDENTIFIER_KEY = "sonar.cloudformation.file.identifier";
    static final String FILE_IDENTIFIER_DEFAULT_VALUE = "AWSTemplateFormatVersion";
    static final String CFN_LINT_REPORTS_KEY = "sonar.cloudformation.cfn-lint.reportPaths";

    private CloudformationSettings() {
    }

    public static List<PropertyDefinition> getGeneralProperties() {
        return Arrays.asList(PropertyDefinition.builder((String)ACTIVATION_KEY).index(1).defaultValue(ACTIVATION_DEFAULT_VALUE).name("Activate CloudFormation analysis").description("Activate analysis of JSON and Yaml files recognized as CloudFormation files.").type(PropertyType.BOOLEAN).onQualifiers("TRK", new String[0]).category(CLOUDFORMATION_CATEGORY).subCategory(GENERAL_SUBCATEGORY).build(), PropertyDefinition.builder((String)FILE_IDENTIFIER_KEY).index(4).defaultValue(FILE_IDENTIFIER_DEFAULT_VALUE).name("File Identifier").description("Files without the identifier are excluded from the analysis. The identifier can be anywhere in the file.").onQualifiers("TRK", new String[0]).category(CLOUDFORMATION_CATEGORY).subCategory(GENERAL_SUBCATEGORY).build());
    }

    public static List<PropertyDefinition> getExternalReportProperties() {
        return List.of(PropertyDefinition.builder((String)CFN_LINT_REPORTS_KEY).index(33).name("Cfn-Lint Report Files").description("Paths (absolute or relative) to the files with Cfn-Lint issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(CLOUDFORMATION_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build());
    }
}

