/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.reports;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.iac.common.reports.ReportImporterException;
import org.sonar.iac.common.warnings.AnalysisWarningsWrapper;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.JSONParser;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public abstract class AbstractJsonReportImporter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJsonReportImporter.class);
    protected static final JSONParser jsonParser = new JSONParser();
    protected final SensorContext context;
    private final AnalysisWarningsWrapper analysisWarnings;
    private final String warningPrefix;
    private Set<String> unresolvedPaths;

    protected AbstractJsonReportImporter(SensorContext context, AnalysisWarningsWrapper analysisWarnings, String warningPrefix) {
        this.context = context;
        this.analysisWarnings = analysisWarnings;
        this.warningPrefix = warningPrefix;
    }

    public void importReport(File reportFile) {
        if (!reportFile.isFile()) {
            String message = String.format("path does not seem to point to a file %s", reportFile.getPath());
            this.logWarning(message);
            return;
        }
        LOG.info("{} Importing external report from: {}", (Object)this.warningPrefix, (Object)reportFile.getPath());
        this.parseJson(reportFile).forEach(issuesJson -> {
            this.unresolvedPaths = new LinkedHashSet<String>();
            int failedToSaveIssues = this.saveIssues((JSONArray)issuesJson);
            if (failedToSaveIssues > 0) {
                this.addWarning(reportFile.getPath(), issuesJson.size(), failedToSaveIssues);
            }
        });
    }

    protected List<JSONArray> parseJson(File reportFile) {
        JSONArray issuesJson = null;
        try {
            issuesJson = this.parseFileAsArray(reportFile);
        }
        catch (IOException e) {
            String message = String.format("could not read report file %s", reportFile.getPath());
            this.logWarning(message);
        }
        catch (ParseException e) {
            String message = String.format("could not parse file as JSON %s", reportFile.getPath());
            this.logWarning(message);
        }
        catch (RuntimeException e) {
            String message = String.format("file is expected to contain a JSON array but didn't %s", reportFile.getPath());
            this.logWarning(message);
        }
        if (issuesJson == null) {
            return Collections.emptyList();
        }
        return List.of(issuesJson);
    }

    protected JSONArray parseFileAsArray(File reportFile) throws IOException, ParseException {
        return (JSONArray)jsonParser.parse(Files.newBufferedReader(reportFile.toPath()));
    }

    protected int saveIssues(JSONArray issuesJson) {
        int failedToSaveIssues = 0;
        for (Object issueJson : issuesJson) {
            try {
                NewExternalIssue externalIssue = this.toExternalIssue((JSONObject)issueJson);
                externalIssue.save();
            }
            catch (RuntimeException e) {
                LOG.debug("failed to save issue", (Throwable)e);
                ++failedToSaveIssues;
            }
        }
        return failedToSaveIssues;
    }

    protected abstract NewExternalIssue toExternalIssue(JSONObject var1);

    protected void logWarning(String message) {
        String warning = this.warningPrefix + message;
        LOG.warn(warning);
        this.analysisWarnings.addWarning(warning);
    }

    protected void addUnresolvedPath(String path) {
        this.unresolvedPaths.add(path);
    }

    protected static int asInt(Object o) {
        return Math.toIntExact((Long)o);
    }

    protected InputFile inputFile(@Nullable String filename) {
        if (filename == null) {
            throw new ReportImporterException("Empty path");
        }
        FilePredicates predicates = this.context.fileSystem().predicates();
        InputFile inputFile = this.context.fileSystem().inputFile(predicates.or(predicates.hasAbsolutePath(filename), predicates.hasRelativePath(filename)));
        if (inputFile == null) {
            this.addUnresolvedPath(filename);
            throw new ReportImporterException(String.format("The file: %s is not resolved", filename));
        }
        return inputFile;
    }

    private void addWarning(String path, int total, int failed) {
        StringBuilder sb = new StringBuilder(String.format("could not save %d out of %d issues from %s.", failed, total, path));
        if (!this.unresolvedPaths.isEmpty()) {
            sb.append(" Some file paths could not be resolved: ");
            sb.append(this.unresolvedPaths.stream().limit(2L).collect(Collectors.joining(", ")));
            sb.append(this.unresolvedPaths.size() > 2 ? ", ..." : "");
        }
        this.logWarning(sb.toString());
    }
}

