/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml.visitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.MetricsVisitor;
import org.sonar.iac.common.yaml.tree.YamlTree;

public class YamlMetricsVisitor
extends MetricsVisitor {
    public YamlMetricsVisitor(FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter) {
        super(fileLinesContextFactory, noSonarFilter);
    }

    @Override
    protected void before(InputFileContext ctx, Tree root) {
        super.before(ctx, root);
        if (this.acceptFileForLoc(ctx)) {
            try {
                this.analyzeFileContentForLoc(ctx.inputFile);
            }
            catch (IOException e) {
                throw new ParseException("Can not read file for metric calculation", null, e.getMessage());
            }
        }
    }

    private void analyzeFileContentForLoc(InputFile inputFile) throws IOException {
        int lineNumber = 1;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputFile.inputStream(), inputFile.charset()));){
            while (reader.ready()) {
                String line = reader.readLine().trim();
                if (!line.isBlank() && !line.startsWith("#")) {
                    this.linesOfCode().add(lineNumber);
                }
                ++lineNumber;
            }
        }
    }

    @Override
    protected void languageSpecificMetrics() {
        this.register(YamlTree.class, (ctx, tree) -> this.addCommentLines(tree.metadata().comments()));
    }

    protected boolean acceptFileForLoc(InputFileContext inputFileContext) {
        return true;
    }
}

