/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.checks.utils.CheckUtils;
import org.sonar.iac.docker.checks.utils.CommandDetector;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.RunInstruction;

@Rule(key="S6505")
public class PackageInstallationScriptExecutionCheck
implements IacCheck {
    private static final String MESSAGE = "Omitting --ignore-scripts can lead to the execution of shell scripts. Make sure it is safe here.";
    private static final String REQUIRED_FLAG = "--ignore-scripts";
    private static final Set<String> NPM_COMMAND = Set.of("npm", "pnpm");
    private static final Set<String> NPM_INSTALL_COMMAND = Set.of("install", "ci", "add", "i", "in", "ins", "inst", "insta", "instal", "isnt", "isnta", "isntal", "isntall");
    private static final CommandDetector NPM_PACKAGE_INSTALLATION = CommandDetector.builder().with(NPM_COMMAND).with(NPM_INSTALL_COMMAND).withAnyFlagExcept("--ignore-scripts").build();
    private static final CommandDetector YARN_PACKAGE_INSTALL = CommandDetector.builder().with("yarn").with("install").withAnyFlagExcept("--ignore-scripts").build();

    @Override
    public void initialize(InitContext init) {
        init.register(RunInstruction.class, PackageInstallationScriptExecutionCheck::checkRunInstruction);
    }

    private static void checkRunInstruction(CheckContext ctx, RunInstruction runInstruction) {
        List<ArgumentResolution> resolvedArgument = CheckUtils.resolveInstructionArguments(runInstruction);
        ArrayList<CommandDetector.Command> sensitiveCommands = new ArrayList<CommandDetector.Command>();
        sensitiveCommands.addAll(NPM_PACKAGE_INSTALLATION.search(resolvedArgument));
        sensitiveCommands.addAll(YARN_PACKAGE_INSTALL.search(resolvedArgument));
        sensitiveCommands.forEach(command -> ctx.reportIssue((HasTextRange)command, MESSAGE));
    }
}

