/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.Flag;
import org.sonar.iac.docker.tree.api.HasArguments;

public class CheckUtils {
    private CheckUtils() {
    }

    public static List<ArgumentResolution> resolveInstructionArguments(HasArguments instructionWithArguments) {
        return instructionWithArguments.arguments().stream().map(ArgumentResolution::of).collect(Collectors.toList());
    }

    public static String getFileExtension(String name) {
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf + 1);
    }

    public static Optional<Flag> getParamByName(List<Flag> params, String name) {
        return params.stream().filter(param -> name.equals(param.name())).findFirst();
    }
}

