/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils.command;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.iac.docker.checks.utils.command.CommandPredicate;
import org.sonar.iac.docker.symbols.ArgumentResolution;

public class PredicateContext {
    private final Deque<ArgumentResolution> argumentStack;
    private final List<CommandPredicate> detectorPredicates;
    private Status status;
    private Deque<CommandPredicate> predicatesStack;
    private List<ArgumentResolution> argumentsToReport;
    private CommandPredicate currentPredicate;

    public PredicateContext(Deque<ArgumentResolution> argumentStack, List<CommandPredicate> detectorPredicates) {
        this.argumentStack = argumentStack;
        this.detectorPredicates = detectorPredicates;
        this.status = Status.CONTINUE;
    }

    public void startNewfullMatchOn(List<CommandPredicate> detectorPredicates) {
        this.predicatesStack = new LinkedList<CommandPredicate>(detectorPredicates);
        this.argumentsToReport = new ArrayList<ArgumentResolution>();
    }

    public boolean is(Status ... statusArray) {
        for (Status specificStatus : statusArray) {
            if (!this.status.equals((Object)specificStatus)) continue;
            return true;
        }
        return false;
    }

    public boolean remainingPredicatesAreOptional() {
        this.predicatesStack.addFirst(this.currentPredicate);
        return this.predicatesStack.stream().noneMatch(predicate -> predicate.hasType(CommandPredicate.Type.MATCH));
    }

    public boolean areNoArgumentsToHandle() {
        return this.argumentStack.isEmpty();
    }

    public ArgumentResolution getNextArgumentToHandle() {
        return this.argumentStack.peekFirst();
    }

    public ArgumentResolution getNextArgumentToHandleAndRemoveFromList() {
        return this.argumentStack.pollFirst();
    }

    public void argumentShouldBeMatchedAgain(ArgumentResolution resolution) {
        this.argumentStack.addFirst(resolution);
    }

    public boolean arePredicatesToDetectLeft() {
        return !this.predicatesStack.isEmpty();
    }

    public void provideNextPredicate() {
        this.currentPredicate = this.predicatesStack.pollFirst();
    }

    public void detectCurrentPredicateAgain() {
        this.predicatesStack.addFirst(this.currentPredicate);
    }

    public void matchOnCurrentPredicate() {
        this.currentPredicate.match(this);
    }

    public int numberOfArgumentsToReport() {
        return this.argumentsToReport.size();
    }

    public void addAsArgumentToReport(ArgumentResolution resolution) {
        this.argumentsToReport.add(resolution);
    }

    public Deque<ArgumentResolution> getArgumentStack() {
        return this.argumentStack;
    }

    public List<CommandPredicate> getDetectorPredicates() {
        return this.detectorPredicates;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<ArgumentResolution> getArgumentsToReport() {
        return this.argumentsToReport;
    }

    public CommandPredicate getCurrentPredicate() {
        return this.currentPredicate;
    }

    public static enum Status {
        CONTINUE,
        ABORT,
        FOUND_NO_PREDICATE_MATCH;

    }
}

