/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.tree;

import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.Tree;

public class TreeUtils {
    private TreeUtils() {
    }

    public static <T extends Tree> Optional<T> firstDescendant(Tree root, Class<T> clazz) {
        return TreeUtils.firstDescendant(root, clazz::isInstance);
    }

    public static Optional<Tree> firstDescendant(@Nullable Tree root, Predicate<Tree> predicate) {
        return TreeUtils.descendants(root).filter(predicate).findFirst();
    }

    public static Optional<Tree> lastDescendant(@Nullable Tree root, Predicate<Tree> predicate) {
        return TreeUtils.descendants(root).filter(predicate).reduce((first, second) -> second);
    }

    private static Stream<Tree> descendants(@Nullable Tree root) {
        if (root == null || root.children().isEmpty()) {
            return Stream.empty();
        }
        Spliterator<Tree> spliterator = Spliterators.spliteratorUnknownSize(root.children().iterator(), 16);
        Stream<Tree> stream = StreamSupport.stream(spliterator, false);
        return stream.flatMap(tree -> Stream.concat(Stream.of(tree), TreeUtils.descendants(tree)));
    }
}

