/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.terraform.checks.aws.AwsDisabledLoggingCheckPart;
import org.sonar.iac.terraform.checks.azure.AzureDisabledLoggingCheckPart;
import org.sonar.iac.terraform.checks.gcp.GcpDisabledLoggingCheckPart;

@Rule(key="S6258")
public class DisabledLoggingCheck
implements IacCheck {
    public static final String MESSAGE = "Make sure that disabling logging is safe here.";
    public static final String MESSAGE_OMITTING = "Omitting %s makes logs incomplete. Make sure it is safe here.";

    @Override
    public void initialize(InitContext init) {
        new AwsDisabledLoggingCheckPart().initialize(init);
        new GcpDisabledLoggingCheckPart().initialize(init);
        new AzureDisabledLoggingCheckPart().initialize(init);
    }
}

