/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ListSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6408")
public class CustomRoleCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure that using a permission that allows privilege escalation is safe here.";
    private static final Set<String> SENSITIVE_LABELS = Stream.of("cloudbuild.builds.create", "cloudfunctions.functions.create", "cloudfunctions.functions.update", "cloudscheduler.jobs.create", "composer.environments.create", "compute.instances.create", "dataflow.jobs.create", "dataproc.clusters.create", "deploymentmanager.deployments.create", "iam.roles.update", "iam.serviceAccountKeys.create", "iam.serviceAccounts.actAs", "iam.serviceAccounts.getAccessToken", "iam.serviceAccounts.getOpenIdToken", "iam.serviceAccounts.implicitDelegation", "iam.serviceAccounts.signBlob", "iam.serviceAccounts.signJwt", "orgpolicy.policy.set", "run.services.create", "serviceusage.apiKeys.create", "serviceusage.apiKeys.list", "storage.hmacKeys.create").map(String::toLowerCase).collect(Collectors.toSet());
    private static final Predicate<ExpressionTree> SENSITIVE_LABEL_PREDICATE = expression -> TextUtils.matchesValue(expression, s -> SENSITIVE_LABELS.contains(s.toLowerCase(Locale.ROOT))).isTrue();

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("google_organization_iam_custom_role", "google_project_iam_custom_role"), (ResourceSymbol resource) -> ((ListSymbol)resource.list("permissions").reportItemIf(SENSITIVE_LABEL_PREDICATE, MESSAGE, new SecondaryLocation[0])).reportItemIf(ExpressionPredicate.matchesPattern(".*\\.setIamPolicy"), MESSAGE, new SecondaryLocation[0]));
    }
}

