/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.launcher;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.elasticsearch.cli.CliToolProvider;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.SuppressForbidden;

class CliToolLauncher {
    private static final String SCRIPT_PREFIX = "elasticsearch-";
    private static volatile Command command;

    CliToolLauncher() {
    }

    public static void main(String[] args) throws Exception {
        ProcessInfo pinfo = ProcessInfo.fromSystem();
        CliToolLauncher.configureLoggingWithoutConfig(pinfo.sysprops());
        String toolname = CliToolLauncher.getToolName(pinfo.sysprops());
        String libs = pinfo.sysprops().getOrDefault("cli.libs", "");
        command = CliToolProvider.load((String)toolname, (String)libs).create();
        Terminal terminal = Terminal.DEFAULT;
        Runtime.getRuntime().addShutdownHook(CliToolLauncher.createShutdownHook(terminal, (Closeable)command));
        int exitCode = command.main(args, terminal, pinfo);
        terminal.flush();
        if (exitCode != 0) {
            CliToolLauncher.exit(exitCode);
        }
    }

    static String getToolName(Map<String, String> sysprops) {
        String toolname = sysprops.getOrDefault("cli.name", "");
        if (toolname.isBlank()) {
            int dotIndex;
            String script = sysprops.get("cli.script");
            int nameStart = script.lastIndexOf(SCRIPT_PREFIX) + SCRIPT_PREFIX.length();
            toolname = script.substring(nameStart);
            if (sysprops.get("os.name").startsWith("Windows") && (dotIndex = toolname.indexOf(".bat")) != -1) {
                toolname = toolname.substring(0, dotIndex);
            }
        }
        return toolname;
    }

    static Thread createShutdownHook(Terminal terminal, Closeable closeable) {
        return new Thread(() -> {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace(terminal.getErrorWriter());
            }
            terminal.flush();
        });
    }

    @SuppressForbidden(reason="System#exit")
    private static void exit(int status) {
        System.exit(status);
    }

    private static void configureLoggingWithoutConfig(Map<String, String> sysprops) {
        String loggerLevel = sysprops.getOrDefault("es.logger.level", Level.INFO.name());
        Settings settings = Settings.builder().put("logger.level", loggerLevel).build();
        LogConfigurator.configureWithoutConfig((Settings)settings);
    }

    static void close(String[] args) throws IOException {
        command.close();
    }
}

