/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.Licensing;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.protocol.xpack.XPackInfoResponse;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.snapshots.sourceonly.SourceOnlySnapshotRepository;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.tracing.Tracer;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.cluster.routing.allocation.DataTierAllocationDecider;
import org.elasticsearch.xpack.cluster.routing.allocation.mapper.DataTierFieldMapper;
import org.elasticsearch.xpack.core.DataTiersInfoTransportAction;
import org.elasticsearch.xpack.core.DataTiersUsageTransportAction;
import org.elasticsearch.xpack.core.HealthApiUsageTransportAction;
import org.elasticsearch.xpack.core.XPackClientPlugin;
import org.elasticsearch.xpack.core.action.DataStreamInfoTransportAction;
import org.elasticsearch.xpack.core.action.DataStreamUsageTransportAction;
import org.elasticsearch.xpack.core.action.ReloadAnalyzerAction;
import org.elasticsearch.xpack.core.action.TransportReloadAnalyzersAction;
import org.elasticsearch.xpack.core.action.TransportXPackInfoAction;
import org.elasticsearch.xpack.core.action.TransportXPackUsageAction;
import org.elasticsearch.xpack.core.action.XPackInfoAction;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageResponse;
import org.elasticsearch.xpack.core.async.DeleteAsyncResultAction;
import org.elasticsearch.xpack.core.async.TransportDeleteAsyncResultAction;
import org.elasticsearch.xpack.core.rest.action.RestReloadAnalyzersAction;
import org.elasticsearch.xpack.core.rest.action.RestXPackInfoAction;
import org.elasticsearch.xpack.core.rest.action.RestXPackUsageAction;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationReloader;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.termsenum.action.TermsEnumAction;
import org.elasticsearch.xpack.core.termsenum.action.TransportTermsEnumAction;
import org.elasticsearch.xpack.core.termsenum.rest.RestTermsEnumAction;

public class XPackPlugin
extends XPackClientPlugin
implements ExtensiblePlugin,
RepositoryPlugin,
EnginePlugin,
ClusterPlugin,
MapperPlugin {
    private static final DeprecationLogger deprecationLogger;
    public static final String ASYNC_RESULTS_INDEX = ".async-search";
    public static final String XPACK_INSTALLED_NODE_ATTR = "xpack.installed";
    protected final Settings settings;
    protected final Licensing licensing;
    private static final SetOnce<XPackLicenseState> licenseState;
    private static final SetOnce<SSLService> sslService;
    private static final SetOnce<LicenseService> licenseService;
    private static final SetOnce<LongSupplier> epochMillisSupplier;

    public XPackPlugin(Settings settings) {
        this.settings = settings;
        this.setLicenseState(new XPackLicenseState(() -> this.getEpochMillisSupplier().getAsLong()));
        this.licensing = new Licensing(settings);
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    protected SSLService getSslService() {
        return XPackPlugin.getSharedSslService();
    }

    protected LicenseService getLicenseService() {
        return XPackPlugin.getSharedLicenseService();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    protected LongSupplier getEpochMillisSupplier() {
        return XPackPlugin.getSharedEpochMillisSupplier();
    }

    protected void setSslService(SSLService sslService) {
        XPackPlugin.sslService.set((Object)sslService);
    }

    protected void setLicenseService(LicenseService licenseService) {
        XPackPlugin.licenseService.set((Object)licenseService);
    }

    protected void setLicenseState(XPackLicenseState licenseState) {
        XPackPlugin.licenseState.set((Object)licenseState);
    }

    protected void setEpochMillisSupplier(LongSupplier epochMillisSupplier) {
        XPackPlugin.epochMillisSupplier.set((Object)epochMillisSupplier);
    }

    public static SSLService getSharedSslService() {
        SSLService ssl = (SSLService)sslService.get();
        if (ssl == null) {
            throw new IllegalStateException("SSL Service is not constructed yet");
        }
        return ssl;
    }

    public static LicenseService getSharedLicenseService() {
        return (LicenseService)licenseService.get();
    }

    public static XPackLicenseState getSharedLicenseState() {
        return (XPackLicenseState)licenseState.get();
    }

    public static LongSupplier getSharedEpochMillisSupplier() {
        return (LongSupplier)epochMillisSupplier.get();
    }

    public static void checkReadyForXPackCustomMetadata(ClusterState clusterState) {
        if (XPackPlugin.alreadyContainsXPackCustomMetadata(clusterState)) {
            return;
        }
        List<DiscoveryNode> notReadyNodes = XPackPlugin.nodesNotReadyForXPackCustomMetadata(clusterState);
        if (!notReadyNodes.isEmpty()) {
            throw new IllegalStateException("The following nodes are not ready yet for enabling x-pack custom metadata: " + notReadyNodes);
        }
    }

    public static boolean isReadyForXPackCustomMetadata(ClusterState clusterState) {
        return XPackPlugin.alreadyContainsXPackCustomMetadata(clusterState) || XPackPlugin.nodesNotReadyForXPackCustomMetadata(clusterState).isEmpty();
    }

    public static List<DiscoveryNode> nodesNotReadyForXPackCustomMetadata(ClusterState clusterState) {
        List<DiscoveryNode> notReadyNodes = clusterState.nodes().stream().filter(node -> {
            String xpackInstalledAttr = node.getAttributes().getOrDefault(XPACK_INSTALLED_NODE_ATTR, "false");
            return !Booleans.parseBoolean((String)xpackInstalledAttr);
        }).collect(Collectors.toList());
        return notReadyNodes;
    }

    private static boolean alreadyContainsXPackCustomMetadata(ClusterState clusterState) {
        Metadata metadata = clusterState.metadata();
        return metadata.custom("licenses") != null || metadata.custom("ml") != null || metadata.custom("watcher") != null || clusterState.custom("security_tokens") != null || metadata.custom("transform") != null;
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
        return Map.of("_tier", DataTierFieldMapper.PARSER);
    }

    public Settings additionalSettings() {
        String xpackInstalledNodeAttrSetting = "node.attr.xpack.installed";
        if (this.settings.get("node.attr.xpack.installed") != null) {
            throw new IllegalArgumentException("Directly setting [node.attr.xpack.installed] is not permitted");
        }
        return Settings.builder().put(super.additionalSettings()).put("node.attr.xpack.installed", "true").build();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, Tracer tracer, AllocationService allocationService) {
        ArrayList<Object> components = new ArrayList<Object>();
        SSLService sslService = this.createSSLService(environment, resourceWatcherService);
        this.setLicenseService(new LicenseService(this.settings, threadPool, clusterService, this.getClock(), environment, resourceWatcherService, this.getLicenseState()));
        this.setEpochMillisSupplier(() -> ((ThreadPool)threadPool).absoluteTimeInMillis());
        components.add(sslService);
        components.add(this.getLicenseService());
        components.add(this.getLicenseState());
        return components;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(new ActionPlugin.ActionHandler((ActionType)XPackInfoAction.INSTANCE, this.getInfoAction()));
        actions.add(new ActionPlugin.ActionHandler((ActionType)XPackUsageAction.INSTANCE, this.getUsageAction()));
        actions.addAll(this.licensing.getActions());
        actions.add(new ActionPlugin.ActionHandler((ActionType)ReloadAnalyzerAction.INSTANCE, TransportReloadAnalyzersAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)TermsEnumAction.INSTANCE, TransportTermsEnumAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)DeleteAsyncResultAction.INSTANCE, TransportDeleteAsyncResultAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.DATA_TIERS, DataTiersInfoTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.DATA_TIERS, DataTiersUsageTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.DATA_STREAMS, DataStreamUsageTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.DATA_STREAMS, DataStreamInfoTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.HEALTH, HealthApiUsageTransportAction.class));
        return actions;
    }

    protected Class<? extends TransportAction<XPackUsageRequest, XPackUsageResponse>> getUsageAction() {
        return TransportXPackUsageAction.class;
    }

    protected Class<? extends TransportAction<XPackInfoRequest, XPackInfoResponse>> getInfoAction() {
        return TransportXPackInfoAction.class;
    }

    @Override
    public List<ActionType<? extends ActionResponse>> getClientActions() {
        ArrayList<ActionType<? extends ActionResponse>> actions = new ArrayList<ActionType<? extends ActionResponse>>();
        actions.addAll(this.licensing.getClientActions());
        actions.addAll(super.getClientActions());
        return actions;
    }

    public List<ActionFilter> getActionFilters() {
        ArrayList<ActionFilter> filters = new ArrayList<ActionFilter>();
        filters.addAll(this.licensing.getActionFilters());
        return filters;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new RestXPackInfoAction());
        handlers.add((RestHandler)new RestXPackUsageAction());
        handlers.add((RestHandler)new RestReloadAnalyzersAction());
        handlers.add((RestHandler)new RestTermsEnumAction());
        handlers.addAll(this.licensing.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, nodesInCluster));
        return handlers;
    }

    public static Path resolveConfigFile(Environment env, String name) {
        Path legacyConfig;
        Path config = env.configFile().resolve(name);
        if (!Files.exists(config, new LinkOption[0]) && Files.exists(legacyConfig = env.configFile().resolve("x-pack").resolve(name), new LinkOption[0])) {
            deprecationLogger.warn(DeprecationCategory.OTHER, "config_file_path", "Config file [" + name + "] is in a deprecated location. Move from " + legacyConfig.toString() + " to " + config.toString(), new Object[0]);
            return legacyConfig;
        }
        return config;
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
        return Collections.singletonMap("source", SourceOnlySnapshotRepository.newRepositoryFactory());
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        if (((Boolean)indexSettings.getValue(SourceOnlySnapshotRepository.SOURCE_ONLY)).booleanValue() && !indexSettings.getIndexMetadata().isSearchableSnapshot()) {
            return Optional.of(SourceOnlySnapshotRepository.getEngineFactory());
        }
        return Optional.empty();
    }

    @Override
    public List<Setting<?>> getSettings() {
        List<Setting<?>> settings = super.getSettings();
        settings.add(SourceOnlySnapshotRepository.SOURCE_ONLY);
        return settings;
    }

    public Collection<AllocationDecider> createAllocationDeciders(Settings settings, ClusterSettings clusterSettings) {
        if (DiscoveryNode.isStateless((Settings)settings)) {
            return List.of();
        }
        return Collections.singleton(DataTierAllocationDecider.INSTANCE);
    }

    public Collection<IndexSettingProvider> getAdditionalIndexSettingProviders(IndexSettingProvider.Parameters parameters) {
        if (DiscoveryNode.isStateless((Settings)this.settings)) {
            return List.of();
        }
        return Collections.singleton(new DataTier.DefaultHotAllocationSettingProvider());
    }

    private SSLService createSSLService(Environment environment, ResourceWatcherService resourceWatcherService) {
        Map<String, SslConfiguration> sslConfigurations = SSLService.getSSLConfigurations(environment);
        SSLConfigurationReloader reloader = new SSLConfigurationReloader(resourceWatcherService, sslConfigurations.values());
        SSLService sslService = new SSLService(environment, sslConfigurations);
        reloader.setSSLService(sslService);
        this.setSslService(sslService);
        return sslService;
    }

    static {
        block3: {
            deprecationLogger = DeprecationLogger.getLogger(XPackPlugin.class);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            Class.forName("com.unboundid.util.Debug");
                            Class.forName("com.unboundid.ldap.sdk.LDAPConnectionOptions");
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
            catch (ExceptionInInitializerError bogus) {
                if (bogus.getCause() instanceof SecurityException) break block3;
                throw bogus;
            }
        }
        licenseState = new SetOnce();
        sslService = new SetOnce();
        licenseService = new SetOnce();
        epochMillisSupplier = new SetOnce();
    }
}

