/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class XPackUsageResponse
extends ActionResponse {
    private final List<XPackFeatureSet.Usage> usages;

    public XPackUsageResponse(List<XPackFeatureSet.Usage> usages) {
        this.usages = Objects.requireNonNull(usages);
    }

    public XPackUsageResponse(StreamInput in) throws IOException {
        this.usages = in.readNamedWriteableList(XPackFeatureSet.Usage.class);
    }

    public List<XPackFeatureSet.Usage> getUsages() {
        return this.usages;
    }

    public void writeTo(StreamOutput out) throws IOException {
        List<XPackFeatureSet.Usage> usagesToWrite = this.usages.stream().filter(usage -> out.getTransportVersion().onOrAfter(usage.getMinimalSupportedVersion())).toList();
        XPackUsageResponse.writeTo(out, usagesToWrite);
    }

    private static void writeTo(StreamOutput out, List<XPackFeatureSet.Usage> usages) throws IOException {
        out.writeNamedWriteableList(usages);
    }
}

