/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class CloseIndexStep
extends AsyncActionStep {
    public static final String NAME = "close-index";

    CloseIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentClusterState, ClusterStateObserver observer, ActionListener<Void> listener) {
        if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
            CloseIndexRequest request = (CloseIndexRequest)new CloseIndexRequest(new String[]{indexMetadata.getIndex().getName()}).masterNodeTimeout(TimeValue.MAX_VALUE);
            this.getClient().admin().indices().close(request, ActionListener.wrap(closeIndexResponse -> {
                if (!closeIndexResponse.isAcknowledged()) {
                    throw new ElasticsearchException("close index request failed to be acknowledged", new Object[0]);
                }
                listener.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

