/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.BranchingStep;
import org.elasticsearch.xpack.core.ilm.CheckNotDataStreamWriteIndexStep;
import org.elasticsearch.xpack.core.ilm.CleanupTargetIndexStep;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitUntilThresholdStep;
import org.elasticsearch.xpack.core.ilm.CopyExecutionStateStep;
import org.elasticsearch.xpack.core.ilm.DeleteStep;
import org.elasticsearch.xpack.core.ilm.DownsampleStep;
import org.elasticsearch.xpack.core.ilm.GenerateUniqueIndexNameStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.ReadOnlyStep;
import org.elasticsearch.xpack.core.ilm.ReplaceDataStreamBackingIndexStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.SwapAliasesAndDeleteSourceIndexStep;
import org.elasticsearch.xpack.core.ilm.WaitForIndexColorStep;
import org.elasticsearch.xpack.core.ilm.WaitForNoFollowersStep;

public class DownsampleAction
implements LifecycleAction {
    public static final String NAME = "downsample";
    public static final String DOWNSAMPLED_INDEX_PREFIX = "downsample-";
    public static final String CONDITIONAL_DATASTREAM_CHECK_KEY = "branch-on-datastream-check";
    public static final String GENERATE_DOWNSAMPLE_STEP_NAME = "generate-downsampled-index-name";
    private static final ParseField FIXED_INTERVAL_FIELD = new ParseField("fixed_interval", new String[0]);
    private static final ConstructingObjectParser<DownsampleAction, Void> PARSER = new ConstructingObjectParser("downsample", a -> new DownsampleAction((DateHistogramInterval)a[0]));
    private final DateHistogramInterval fixedInterval;

    public static DownsampleAction parse(XContentParser parser) {
        return (DownsampleAction)PARSER.apply(parser, null);
    }

    public DownsampleAction(DateHistogramInterval fixedInterval) {
        if (fixedInterval == null) {
            throw new IllegalArgumentException("Parameter [" + FIXED_INTERVAL_FIELD.getPreferredName() + "] is required.");
        }
        this.fixedInterval = fixedInterval;
    }

    public DownsampleAction(StreamInput in) throws IOException {
        this(new DateHistogramInterval(in));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.fixedInterval.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIXED_INTERVAL_FIELD.getPreferredName(), this.fixedInterval.toString());
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public DateHistogramInterval fixedInterval() {
        return this.fixedInterval;
    }

    @Override
    public boolean isSafeAction() {
        return false;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey checkNotWriteIndex = new Step.StepKey(phase, NAME, "check-not-write-index");
        Step.StepKey waitForNoFollowerStepKey = new Step.StepKey(phase, NAME, "wait-for-shard-history-leases");
        Step.StepKey readOnlyKey = new Step.StepKey(phase, NAME, "readonly");
        Step.StepKey cleanupRollupIndexKey = new Step.StepKey(phase, NAME, "cleanup-target-index");
        Step.StepKey generateRollupIndexNameKey = new Step.StepKey(phase, NAME, GENERATE_DOWNSAMPLE_STEP_NAME);
        Step.StepKey rollupKey = new Step.StepKey(phase, NAME, "rollup");
        Step.StepKey waitForRollupIndexKey = new Step.StepKey(phase, NAME, "wait-for-index-color");
        Step.StepKey copyMetadataKey = new Step.StepKey(phase, NAME, "copy-execution-state");
        Step.StepKey dataStreamCheckBranchingKey = new Step.StepKey(phase, NAME, CONDITIONAL_DATASTREAM_CHECK_KEY);
        Step.StepKey replaceDataStreamIndexKey = new Step.StepKey(phase, NAME, "replace-datastream-backing-index");
        Step.StepKey deleteIndexKey = new Step.StepKey(phase, NAME, "delete");
        Step.StepKey swapAliasesKey = new Step.StepKey(phase, NAME, "swap-aliases");
        CheckNotDataStreamWriteIndexStep checkNotWriteIndexStep = new CheckNotDataStreamWriteIndexStep(checkNotWriteIndex, waitForNoFollowerStepKey);
        WaitForNoFollowersStep waitForNoFollowersStep = new WaitForNoFollowersStep(waitForNoFollowerStepKey, cleanupRollupIndexKey, client);
        CleanupTargetIndexStep cleanupRollupIndexStep = new CleanupTargetIndexStep(cleanupRollupIndexKey, readOnlyKey, client, indexMetadata -> (String)IndexMetadata.INDEX_DOWNSAMPLE_SOURCE_NAME.get(indexMetadata.getSettings()), indexMetadata -> indexMetadata.getLifecycleExecutionState().downsampleIndexName());
        ReadOnlyStep readOnlyStep = new ReadOnlyStep(readOnlyKey, generateRollupIndexNameKey, client);
        GenerateUniqueIndexNameStep generateRollupIndexNameStep = new GenerateUniqueIndexNameStep(generateRollupIndexNameKey, rollupKey, DOWNSAMPLED_INDEX_PREFIX, (rollupIndexName, lifecycleStateBuilder) -> lifecycleStateBuilder.setRollupIndexName(rollupIndexName));
        DownsampleStep rollupStep = new DownsampleStep(rollupKey, waitForRollupIndexKey, client, this.fixedInterval);
        ClusterStateWaitUntilThresholdStep rollupAllocatedStep = new ClusterStateWaitUntilThresholdStep(new WaitForIndexColorStep(waitForRollupIndexKey, copyMetadataKey, ClusterHealthStatus.YELLOW, (indexName, lifecycleState) -> lifecycleState.downsampleIndexName()), cleanupRollupIndexKey);
        CopyExecutionStateStep copyExecutionStateStep = new CopyExecutionStateStep(copyMetadataKey, dataStreamCheckBranchingKey, (indexName, lifecycleState) -> lifecycleState.downsampleIndexName(), nextStepKey);
        BranchingStep isDataStreamBranchingStep = new BranchingStep(dataStreamCheckBranchingKey, swapAliasesKey, replaceDataStreamIndexKey, (index, clusterState) -> {
            IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(index.getName());
            assert (indexAbstraction != null) : "invalid cluster metadata. index [" + index.getName() + "] was not found";
            return indexAbstraction.getParentDataStream() != null;
        });
        ReplaceDataStreamBackingIndexStep replaceDataStreamBackingIndex = new ReplaceDataStreamBackingIndexStep(replaceDataStreamIndexKey, deleteIndexKey, (sourceIndexName, lifecycleState) -> lifecycleState.downsampleIndexName());
        DeleteStep deleteSourceIndexStep = new DeleteStep(deleteIndexKey, nextStepKey, client);
        SwapAliasesAndDeleteSourceIndexStep swapAliasesAndDeleteSourceIndexStep = new SwapAliasesAndDeleteSourceIndexStep(swapAliasesKey, nextStepKey, client, (indexName, lifecycleState) -> lifecycleState.downsampleIndexName(), false);
        return List.of(checkNotWriteIndexStep, waitForNoFollowersStep, cleanupRollupIndexStep, readOnlyStep, generateRollupIndexNameStep, rollupStep, rollupAllocatedStep, copyExecutionStateStep, isDataStreamBranchingStep, replaceDataStreamBackingIndex, deleteSourceIndexStep, swapAliasesAndDeleteSourceIndexStep);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownsampleAction that = (DownsampleAction)o;
        return Objects.equals(this.fixedInterval, that.fixedInterval);
    }

    public int hashCode() {
        return Objects.hash(this.fixedInterval);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> new DateHistogramInterval(p.text()), FIXED_INTERVAL_FIELD, ObjectParser.ValueType.STRING);
    }
}

