/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.RolloverStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UpdateRolloverLifecycleDateStep;
import org.elasticsearch.xpack.core.ilm.UpdateSettingsStep;
import org.elasticsearch.xpack.core.ilm.WaitForActiveShardsStep;
import org.elasticsearch.xpack.core.ilm.WaitForRolloverReadyStep;

public class RolloverAction
implements LifecycleAction {
    public static final String NAME = "rollover";
    public static final String INDEXING_COMPLETE_STEP_NAME = "set-indexing-complete";
    public static final ParseField MAX_SIZE_FIELD = new ParseField("max_size", new String[0]);
    public static final ParseField MAX_PRIMARY_SHARD_SIZE_FIELD = new ParseField("max_primary_shard_size", new String[0]);
    public static final ParseField MAX_DOCS_FIELD = new ParseField("max_docs", new String[0]);
    public static final ParseField MAX_AGE_FIELD = new ParseField("max_age", new String[0]);
    public static final ParseField MAX_PRIMARY_SHARD_DOCS_FIELD = new ParseField("max_primary_shard_docs", new String[0]);
    public static final ParseField MIN_SIZE_FIELD = new ParseField("min_size", new String[0]);
    public static final ParseField MIN_PRIMARY_SHARD_SIZE_FIELD = new ParseField("min_primary_shard_size", new String[0]);
    public static final ParseField MIN_DOCS_FIELD = new ParseField("min_docs", new String[0]);
    public static final ParseField MIN_AGE_FIELD = new ParseField("min_age", new String[0]);
    public static final ParseField MIN_PRIMARY_SHARD_DOCS_FIELD = new ParseField("min_primary_shard_docs", new String[0]);
    public static final String LIFECYCLE_ROLLOVER_ALIAS = "index.lifecycle.rollover_alias";
    public static final Setting<String> LIFECYCLE_ROLLOVER_ALIAS_SETTING = Setting.simpleString((String)"index.lifecycle.rollover_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    private static final Settings INDEXING_COMPLETE = Settings.builder().put("index.lifecycle.indexing_complete", true).build();
    private static final ConstructingObjectParser<RolloverAction, Void> PARSER = new ConstructingObjectParser("rollover", a -> new RolloverAction((ByteSizeValue)a[0], (ByteSizeValue)a[1], (TimeValue)a[2], (Long)a[3], (Long)a[4], (ByteSizeValue)a[5], (ByteSizeValue)a[6], (TimeValue)a[7], (Long)a[8], (Long)a[9]));
    private final ByteSizeValue maxSize;
    private final ByteSizeValue maxPrimaryShardSize;
    private final Long maxDocs;
    private final TimeValue maxAge;
    private final Long maxPrimaryShardDocs;
    private final ByteSizeValue minSize;
    private final ByteSizeValue minPrimaryShardSize;
    private final Long minDocs;
    private final TimeValue minAge;
    private final Long minPrimaryShardDocs;

    public static RolloverAction parse(XContentParser parser) {
        return (RolloverAction)PARSER.apply(parser, null);
    }

    public RolloverAction(@Nullable ByteSizeValue maxSize, @Nullable ByteSizeValue maxPrimaryShardSize, @Nullable TimeValue maxAge, @Nullable Long maxDocs, @Nullable Long maxPrimaryShardDocs, @Nullable ByteSizeValue minSize, @Nullable ByteSizeValue minPrimaryShardSize, @Nullable TimeValue minAge, @Nullable Long minDocs, @Nullable Long minPrimaryShardDocs) {
        if (maxSize == null && maxPrimaryShardSize == null && maxAge == null && maxDocs == null && maxPrimaryShardDocs == null) {
            throw new IllegalArgumentException("At least one max_* rollover condition must be set.");
        }
        this.maxSize = maxSize;
        this.maxPrimaryShardSize = maxPrimaryShardSize;
        this.maxAge = maxAge;
        this.maxDocs = maxDocs;
        this.maxPrimaryShardDocs = maxPrimaryShardDocs;
        this.minSize = minSize;
        this.minPrimaryShardSize = minPrimaryShardSize;
        this.minAge = minAge;
        this.minDocs = minDocs;
        this.minPrimaryShardDocs = minPrimaryShardDocs;
    }

    public RolloverAction(StreamInput in) throws IOException {
        this.maxSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::readFrom);
        this.maxPrimaryShardSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::readFrom);
        this.maxAge = in.readOptionalTimeValue();
        this.maxDocs = in.readOptionalVLong();
        this.maxPrimaryShardDocs = in.getTransportVersion().onOrAfter(TransportVersion.V_8_2_0) ? in.readOptionalVLong() : null;
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_4_0)) {
            this.minSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::readFrom);
            this.minPrimaryShardSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::readFrom);
            this.minAge = in.readOptionalTimeValue();
            this.minDocs = in.readOptionalVLong();
            this.minPrimaryShardDocs = in.readOptionalVLong();
        } else {
            this.minSize = null;
            this.minPrimaryShardSize = null;
            this.minAge = null;
            this.minDocs = null;
            this.minPrimaryShardDocs = null;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.maxSize);
        out.writeOptionalWriteable((Writeable)this.maxPrimaryShardSize);
        out.writeOptionalTimeValue(this.maxAge);
        out.writeOptionalVLong(this.maxDocs);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_2_0)) {
            out.writeOptionalVLong(this.maxPrimaryShardDocs);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_4_0)) {
            out.writeOptionalWriteable((Writeable)this.minSize);
            out.writeOptionalWriteable((Writeable)this.minPrimaryShardSize);
            out.writeOptionalTimeValue(this.minAge);
            out.writeOptionalVLong(this.minDocs);
            out.writeOptionalVLong(this.minPrimaryShardDocs);
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    public ByteSizeValue getMaxSize() {
        return this.maxSize;
    }

    public ByteSizeValue getMaxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    public TimeValue getMaxAge() {
        return this.maxAge;
    }

    public Long getMaxDocs() {
        return this.maxDocs;
    }

    public Long getMaxPrimaryShardDocs() {
        return this.maxPrimaryShardDocs;
    }

    public ByteSizeValue getMinSize() {
        return this.minSize;
    }

    public ByteSizeValue getMinPrimaryShardSize() {
        return this.minPrimaryShardSize;
    }

    public TimeValue getMinAge() {
        return this.minAge;
    }

    public Long getMinDocs() {
        return this.minDocs;
    }

    public Long getMinPrimaryShardDocs() {
        return this.minPrimaryShardDocs;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.maxSize != null) {
            builder.field(MAX_SIZE_FIELD.getPreferredName(), this.maxSize.getStringRep());
        }
        if (this.maxPrimaryShardSize != null) {
            builder.field(MAX_PRIMARY_SHARD_SIZE_FIELD.getPreferredName(), this.maxPrimaryShardSize.getStringRep());
        }
        if (this.maxAge != null) {
            builder.field(MAX_AGE_FIELD.getPreferredName(), this.maxAge.getStringRep());
        }
        if (this.maxDocs != null) {
            builder.field(MAX_DOCS_FIELD.getPreferredName(), this.maxDocs);
        }
        if (this.maxPrimaryShardDocs != null) {
            builder.field(MAX_PRIMARY_SHARD_DOCS_FIELD.getPreferredName(), this.maxPrimaryShardDocs);
        }
        if (this.minSize != null) {
            builder.field(MIN_SIZE_FIELD.getPreferredName(), this.minSize.getStringRep());
        }
        if (this.minPrimaryShardSize != null) {
            builder.field(MIN_PRIMARY_SHARD_SIZE_FIELD.getPreferredName(), this.minPrimaryShardSize.getStringRep());
        }
        if (this.minAge != null) {
            builder.field(MIN_AGE_FIELD.getPreferredName(), this.minAge.getStringRep());
        }
        if (this.minDocs != null) {
            builder.field(MIN_DOCS_FIELD.getPreferredName(), this.minDocs);
        }
        if (this.minPrimaryShardDocs != null) {
            builder.field(MIN_PRIMARY_SHARD_DOCS_FIELD.getPreferredName(), this.minPrimaryShardDocs);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey waitForRolloverReadyStepKey = new Step.StepKey(phase, NAME, "check-rollover-ready");
        Step.StepKey rolloverStepKey = new Step.StepKey(phase, NAME, "attempt-rollover");
        Step.StepKey waitForActiveShardsKey = new Step.StepKey(phase, NAME, "wait-for-active-shards");
        Step.StepKey updateDateStepKey = new Step.StepKey(phase, NAME, "update-rollover-lifecycle-date");
        Step.StepKey setIndexingCompleteStepKey = new Step.StepKey(phase, NAME, INDEXING_COMPLETE_STEP_NAME);
        WaitForRolloverReadyStep waitForRolloverReadyStep = new WaitForRolloverReadyStep(waitForRolloverReadyStepKey, rolloverStepKey, client, this.maxSize, this.maxPrimaryShardSize, this.maxAge, this.maxDocs, this.maxPrimaryShardDocs, this.minSize, this.minPrimaryShardSize, this.minAge, this.minDocs, this.minPrimaryShardDocs);
        RolloverStep rolloverStep = new RolloverStep(rolloverStepKey, waitForActiveShardsKey, client);
        WaitForActiveShardsStep waitForActiveShardsStep = new WaitForActiveShardsStep(waitForActiveShardsKey, updateDateStepKey);
        UpdateRolloverLifecycleDateStep updateDateStep = new UpdateRolloverLifecycleDateStep(updateDateStepKey, setIndexingCompleteStepKey, System::currentTimeMillis);
        UpdateSettingsStep setIndexingCompleteStep = new UpdateSettingsStep(setIndexingCompleteStepKey, nextStepKey, client, INDEXING_COMPLETE);
        return Arrays.asList(waitForRolloverReadyStep, rolloverStep, waitForActiveShardsStep, updateDateStep, setIndexingCompleteStep);
    }

    public int hashCode() {
        return Objects.hash(this.maxSize, this.maxPrimaryShardSize, this.maxAge, this.maxDocs, this.maxPrimaryShardDocs, this.minSize, this.minPrimaryShardSize, this.minAge, this.minDocs, this.minPrimaryShardDocs);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RolloverAction other = (RolloverAction)obj;
        return Objects.equals(this.maxSize, other.maxSize) && Objects.equals(this.maxPrimaryShardSize, other.maxPrimaryShardSize) && Objects.equals(this.maxAge, other.maxAge) && Objects.equals(this.maxDocs, other.maxDocs) && Objects.equals(this.maxPrimaryShardDocs, other.maxPrimaryShardDocs) && Objects.equals(this.minSize, other.minSize) && Objects.equals(this.minPrimaryShardSize, other.minPrimaryShardSize) && Objects.equals(this.minAge, other.minAge) && Objects.equals(this.minDocs, other.minDocs) && Objects.equals(this.minPrimaryShardDocs, other.minPrimaryShardDocs);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_SIZE_FIELD.getPreferredName()), MAX_SIZE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_PRIMARY_SHARD_SIZE_FIELD.getPreferredName()), MAX_PRIMARY_SHARD_SIZE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)MAX_AGE_FIELD.getPreferredName()), MAX_AGE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), MAX_DOCS_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), MAX_PRIMARY_SHARD_DOCS_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MIN_SIZE_FIELD.getPreferredName()), MIN_SIZE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MIN_PRIMARY_SHARD_SIZE_FIELD.getPreferredName()), MIN_PRIMARY_SHARD_SIZE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)MIN_AGE_FIELD.getPreferredName()), MIN_AGE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), MIN_DOCS_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), MIN_PRIMARY_SHARD_DOCS_FIELD);
    }
}

