/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.AsyncWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.SingleMessageFieldInfo;

public class WaitForNoFollowersStep
extends AsyncWaitStep {
    private static final Logger logger = LogManager.getLogger(WaitForNoFollowersStep.class);
    static final String NAME = "wait-for-shard-history-leases";
    static final String CCR_LEASE_KEY = "ccr";
    private static final String WAIT_MESSAGE = "this index is a leader index; waiting for all following indices to cease following before proceeding";

    WaitForNoFollowersStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void evaluateCondition(Metadata metadata, Index index, AsyncWaitStep.Listener listener, TimeValue masterTimeout) {
        IndicesStatsRequest request = new IndicesStatsRequest();
        request.clear();
        String indexName = index.getName();
        request.indices(new String[]{indexName});
        this.getClient().admin().indices().stats(request, ActionListener.wrap(response -> {
            IndexStats indexStats = response.getIndex(indexName);
            if (indexStats == null) {
                logger.debug("got null shard stats for index {}, proceeding on the assumption it has been deleted", (Object)indexName);
                listener.onResponse(true, null);
                return;
            }
            boolean isCurrentlyLeaderIndex = Arrays.stream(indexStats.getShards()).map(ShardStats::getRetentionLeaseStats).map(Optional::ofNullable).map(o -> o.flatMap(stats -> Optional.ofNullable(stats.retentionLeases()))).map(o -> o.flatMap(leases -> Optional.ofNullable(leases.leases()))).map(o -> o.map(Collection::stream)).anyMatch(lease -> lease.isPresent() && ((Stream)lease.get()).anyMatch(l -> CCR_LEASE_KEY.equals(l.source())));
            if (isCurrentlyLeaderIndex) {
                listener.onResponse(false, new SingleMessageFieldInfo(WAIT_MESSAGE));
            } else {
                listener.onResponse(true, null);
            }
        }, listener::onFailure));
    }
}

