/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.assignment;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class RoutingInfo
implements ToXContentObject,
Writeable {
    private static final ParseField CURRENT_ALLOCATIONS = new ParseField("current_allocations", new String[0]);
    private static final ParseField TARGET_ALLOCATIONS = new ParseField("target_allocations", new String[0]);
    private static final ParseField ROUTING_STATE = new ParseField("routing_state", new String[0]);
    private static final ParseField REASON = new ParseField("reason", new String[0]);
    private static final ConstructingObjectParser<RoutingInfo, Void> PARSER = new ConstructingObjectParser("trained_model_routing_state", a -> new RoutingInfo((Integer)a[0], (Integer)a[1], RoutingState.fromString((String)a[2]), (String)a[3]));
    private final int currentAllocations;
    private final int targetAllocations;
    private final RoutingState state;
    private final String reason;

    public static RoutingInfo fromXContent(XContentParser parser) {
        return (RoutingInfo)PARSER.apply(parser, null);
    }

    private RoutingInfo(@Nullable Integer currentAllocations, @Nullable Integer targetAllocations, RoutingState state, @Nullable String reason) {
        this(currentAllocations == null ? 0 : currentAllocations, targetAllocations == null ? 0 : targetAllocations, state, reason);
    }

    public RoutingInfo(int currentAllocations, int targetAllocations, RoutingState state, String reason) {
        this.currentAllocations = currentAllocations;
        this.targetAllocations = targetAllocations;
        this.state = ExceptionsHelper.requireNonNull(state, ROUTING_STATE);
        this.reason = reason;
    }

    public RoutingInfo(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_4_0)) {
            this.currentAllocations = in.readVInt();
            this.targetAllocations = in.readVInt();
        } else {
            this.currentAllocations = 0;
            this.targetAllocations = 0;
        }
        this.state = (RoutingState)in.readEnum(RoutingState.class);
        this.reason = in.readOptionalString();
    }

    public int getCurrentAllocations() {
        return this.currentAllocations;
    }

    public int getTargetAllocations() {
        return this.targetAllocations;
    }

    public RoutingState getState() {
        return this.state;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public boolean isOutdated() {
        return this.currentAllocations == 0 && this.targetAllocations == 0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_4_0)) {
            out.writeVInt(this.currentAllocations);
            out.writeVInt(this.targetAllocations);
        }
        out.writeEnum((Enum)this.state);
        out.writeOptionalString(this.reason);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CURRENT_ALLOCATIONS.getPreferredName(), this.currentAllocations);
        builder.field(TARGET_ALLOCATIONS.getPreferredName(), this.targetAllocations);
        builder.field(ROUTING_STATE.getPreferredName(), (Enum)this.state);
        if (this.reason != null) {
            builder.field(REASON.getPreferredName(), this.reason);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingInfo that = (RoutingInfo)o;
        return this.currentAllocations == that.currentAllocations && this.targetAllocations == that.targetAllocations && this.state == that.state && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.currentAllocations, this.targetAllocations, this.state, this.reason);
    }

    public String toString() {
        return "RoutingInfo{current_allocations=" + this.currentAllocations + ", target_allocations=" + this.targetAllocations + ", reason='" + this.reason + "', state=" + this.state + "}";
    }

    public boolean isRoutable() {
        return this.state == RoutingState.STARTED && this.currentAllocations > 0;
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), CURRENT_ALLOCATIONS);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), TARGET_ALLOCATIONS);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ROUTING_STATE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON);
    }
}

