/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.rollup.job.DateHistogramGroupConfig;
import org.elasticsearch.xpack.core.rollup.job.GroupConfig;
import org.elasticsearch.xpack.core.rollup.job.HistogramGroupConfig;
import org.elasticsearch.xpack.core.rollup.job.MetricConfig;
import org.elasticsearch.xpack.core.rollup.job.RollupJobConfig;
import org.elasticsearch.xpack.core.rollup.job.TermsGroupConfig;

public class RollupJobCaps
implements Writeable,
ToXContentObject {
    private static ParseField JOB_ID = new ParseField("job_id", new String[0]);
    private static ParseField ROLLUP_INDEX = new ParseField("rollup_index", new String[0]);
    private static ParseField INDEX_PATTERN = new ParseField("index_pattern", new String[0]);
    private static ParseField FIELDS = new ParseField("fields", new String[0]);
    private final String jobID;
    private final String rollupIndex;
    private final String indexPattern;
    private final Map<String, RollupFieldCaps> fieldCapLookup;

    public RollupJobCaps(RollupJobConfig job) {
        this.jobID = job.getId();
        this.rollupIndex = job.getRollupIndex();
        this.indexPattern = job.getIndexPattern();
        this.fieldCapLookup = RollupJobCaps.createRollupFieldCaps(job);
    }

    public RollupJobCaps(String jobID, String rollupIndex, String indexPattern, Map<String, RollupFieldCaps> fieldCapLookup) {
        this.jobID = jobID;
        this.rollupIndex = rollupIndex;
        this.indexPattern = indexPattern;
        this.fieldCapLookup = Collections.unmodifiableMap(Objects.requireNonNull(fieldCapLookup));
    }

    public RollupJobCaps(StreamInput in) throws IOException {
        this.jobID = in.readString();
        this.rollupIndex = in.readString();
        this.indexPattern = in.readString();
        this.fieldCapLookup = in.readMap(StreamInput::readString, RollupFieldCaps::new);
    }

    public Map<String, RollupFieldCaps> getFieldCaps() {
        return this.fieldCapLookup;
    }

    public String getRollupIndex() {
        return this.rollupIndex;
    }

    public String getIndexPattern() {
        return this.indexPattern;
    }

    public String getJobID() {
        return this.jobID;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobID);
        out.writeString(this.rollupIndex);
        out.writeString(this.indexPattern);
        out.writeMap(this.fieldCapLookup, StreamOutput::writeString, (o, value) -> value.writeTo(o));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(JOB_ID.getPreferredName(), this.jobID);
        builder.field(ROLLUP_INDEX.getPreferredName(), this.rollupIndex);
        builder.field(INDEX_PATTERN.getPreferredName(), this.indexPattern);
        builder.startObject(FIELDS.getPreferredName());
        for (Map.Entry<String, RollupFieldCaps> fieldCap : this.fieldCapLookup.entrySet()) {
            builder.xContentList(fieldCap.getKey(), new ToXContent[]{(ToXContent)fieldCap.getValue()});
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupJobCaps that = (RollupJobCaps)other;
        return Objects.equals(this.jobID, that.jobID) && Objects.equals(this.rollupIndex, that.rollupIndex) && Objects.equals(this.fieldCapLookup, that.fieldCapLookup);
    }

    public int hashCode() {
        return Objects.hash(this.jobID, this.rollupIndex, this.fieldCapLookup, this.indexPattern);
    }

    private static Map<String, RollupFieldCaps> createRollupFieldCaps(RollupJobConfig rollupJobConfig) {
        List<MetricConfig> metricsConfig;
        HashMap<String, List> tempFieldCaps = new HashMap<String, List>();
        GroupConfig groupConfig = rollupJobConfig.getGroupConfig();
        if (groupConfig != null) {
            TermsGroupConfig terms;
            DateHistogramGroupConfig dateHistogram = groupConfig.getDateHistogram();
            HashMap<String, String> dateHistogramAggCap = new HashMap<String, String>();
            dateHistogramAggCap.put("agg", "date_histogram");
            dateHistogramAggCap.put(dateHistogram.getIntervalTypeName(), dateHistogram.getInterval().toString());
            if (dateHistogram.getDelay() != null) {
                dateHistogramAggCap.put("delay", dateHistogram.getDelay().toString());
            }
            dateHistogramAggCap.put("time_zone", dateHistogram.getTimeZone());
            List dateAggCaps = tempFieldCaps.getOrDefault(dateHistogram.getField(), new ArrayList());
            dateAggCaps.add(dateHistogramAggCap);
            tempFieldCaps.put(dateHistogram.getField(), dateAggCaps);
            HistogramGroupConfig histogram = groupConfig.getHistogram();
            if (histogram != null) {
                HashMap<String, Object> histogramAggCap = new HashMap<String, Object>();
                histogramAggCap.put("agg", "histogram");
                histogramAggCap.put("interval", histogram.getInterval());
                Arrays.stream(rollupJobConfig.getGroupConfig().getHistogram().getFields()).forEach(field -> {
                    List caps = tempFieldCaps.getOrDefault(field, new ArrayList());
                    caps.add(histogramAggCap);
                    tempFieldCaps.put((String)field, caps);
                });
            }
            if ((terms = groupConfig.getTerms()) != null) {
                Map<String, String> termsAggCap = Collections.singletonMap("agg", "terms");
                Arrays.stream(rollupJobConfig.getGroupConfig().getTerms().getFields()).forEach(field -> {
                    List caps = tempFieldCaps.getOrDefault(field, new ArrayList());
                    caps.add(termsAggCap);
                    tempFieldCaps.put((String)field, caps);
                });
            }
        }
        if ((metricsConfig = rollupJobConfig.getMetricsConfig()).size() > 0) {
            rollupJobConfig.getMetricsConfig().forEach(metricConfig -> {
                List<Map> metrics = metricConfig.getMetrics().stream().map(metric -> Collections.singletonMap("agg", metric)).collect(Collectors.toList());
                metrics.forEach(m -> {
                    List caps = tempFieldCaps.getOrDefault(metricConfig.getField(), new ArrayList());
                    caps.add(m);
                    tempFieldCaps.put(metricConfig.getField(), caps);
                });
            });
        }
        return Collections.unmodifiableMap(tempFieldCaps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new RollupFieldCaps((List)e.getValue()))));
    }

    public static class RollupFieldCaps
    implements Writeable,
    ToXContentFragment {
        private final List<Map<String, Object>> aggs;

        RollupFieldCaps(StreamInput in) throws IOException {
            int size = in.readInt();
            ArrayList<Map> inAggs = new ArrayList<Map>(size);
            for (int i = 0; i < size; ++i) {
                inAggs.add(in.readMap());
            }
            this.aggs = Collections.unmodifiableList(inAggs);
        }

        RollupFieldCaps(List<Map<String, Object>> aggs) {
            this.aggs = Collections.unmodifiableList(Objects.requireNonNull(aggs));
        }

        public List<Map<String, Object>> getAggs() {
            return this.aggs;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.aggs.size());
            for (Map<String, Object> agg : this.aggs) {
                out.writeGenericMap(agg);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            for (Map<String, Object> agg : this.aggs) {
                builder.map(agg);
            }
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RollupFieldCaps that = (RollupFieldCaps)other;
            return Objects.equals(this.aggs, that.aggs);
        }

        public int hashCode() {
            return Objects.hash(this.aggs);
        }
    }
}

